<?php

use WTS_EAE\Modules\PostList\Widgets\PostList;

/**
 * The admin bud plugin class.
 * I am THE file that defines the gloubi boulga admin bud plugin class
 * A class definition that includes attributes and functions used across the admin area.
 *
 * @link       http://gloubiboulga.com
 * @since      1901
 *
 * @package    Gloubi_Boulga
 * @author     Gloubi_Boulga's author
 */


class Glb_Core_Admin extends Glb_Plugin_Bud {

    public function __construct($plugin) {
        parent::__construct($plugin);
        $this->plugin->add_admin_menu('Gloubi-Boulga', 'Gloubi-Boulga', 'manage_options', 'glb_admin_page',
            array($this, 'admin_page'), 'dashicons-welcome-learn-more', '2.1');

        // add sub menu
        $this->plugin->add_admin_sub_menu('glb_admin_page', 'Settings', __glb('Gloubal admin'), 'manage_options',
            'glb_admin_page', array($this, 'admin_page')
        );
    }

    /**
     * @function run : runs the requested actions for this bud
     */
    public function run() {
        parent::run();
        $this->plugin->add_action('admin_notices', [$this, 'render_notices'], 0);
    }

    /**
     * @function admin_page : receives wp notification to display admin page
     */
    public function admin_page() {

        //Glb_Html::add('glb_security_failure', 'gloubi-boulga:elements/glb-security-failure');
        //die(Glb_Html::get('glb_security_failure')->html());

        $tab = $this->request->get_get('tab', 'settings');
        $data = $this->request->get_post();
        $params = [];

        if ($tab  == 'settings') {
            // save settings if needed
            if ($this->request->get_post('glb_core_settings_submit') !== null) {
                $this->request->check_nonce('glb-core-admin-settings-submit');
                $params['settings'] = $this->plugin->settings->patch_and_save();
                $this->notices->add(__glb('Settings were saved.'));
            } else {
                $params['settings'] = $this->plugin->settings->get();
            }
        } else if ($tab  == 'tools') {
            if ($this->request->get_post('glb_core_tools_silence_is_golden') !== null) {
                $this->request->check_nonce('glb-core-admin-tools-submit');
                Glb_Security::ensure_silence_is_golden();
            }
            if ($this->request->get_post('glb_core_tools_unit_tests') !== null) {
                $this->request->check_nonce('glb-core-admin-tools-submit');
                $params['unit_tests'] = $this->plugin->run_tests();
            }
        } else if ($tab  == 'system') {
            $sys_props = [];
            $sys_props['server_software'] = ['label' => __glb('Server software'), 'value' => $_SERVER['SERVER_SOFTWARE']];
            $sys_props['php_version'] = ['label' => __glb('Php version'), 'value' => phpversion()];
            $sys_props['upload_max_filesize'] = ['label' => __glb('Max. upload file size'), 'value' => ini_get('upload_max_filesize')];
            $sys_props['post_max_size'] = ['label' => __glb('Max. post size'), 'value' => ini_get('post_max_size')];
            $sys_props['memory_limit'] = ['label' => __glb('Memory limit'), 'value' => ini_get('memory_limit')];
            $sys_props['max_execution_time'] = ['label' => __glb('Max execution time'), 'value' => ini_get('max_execution_time')];
            $params['sys_props'] = $sys_props;

        } else if ($tab == 'generator') {

            if ($this->request->get_post('glb_core_generator_submit') !== null) {

                $this->request->check_nonce('glb-core-generator-process');
                $this->request->check_exists($data, ['name', 'short_name', 'description', 'version', 'description',
                    'link', 'main_use', 'author', 'author_url', 'license', 'license_url']);
                $this->request->check_hacks($data, ['name', 'short_name', 'description', 'version', 'description',
                    'link', 'main_use', 'author', 'author_url', 'license', 'license_url']);
                $this->request->check_not_empty($data, ['name', 'short_name', 'description', 'version']);

                /*$data['name']
                $data['short_name']
                $data['version']
                $data['description']
                $data['link']
                $data['main_use']
                $data['author']
                $data['author_url']
                $data['license']
                $data['license_url']*/

                $data['sname'] = $data['short_name'];
                $data['main_use_sing'] = Glb_Text::singularize($data['main_use']);
                if (empty($data['main_use_sing'])) { $data['main_use_sing'] = $data['main_use']; }
                $data['main_use_plur'] = Glb_Text::pluralize($data['main_use']);
                if (empty($data['main_use_plur'])) { $data['main_use_plur'] = $data['main_use']; }

                $variables = [];
                // read data / create variables
                foreach ($data as $data_key => $data_value) {
                    $variables["generator_$data_key"] = $data_value;
                }

                $name_delimited = Glb_Text::delimit($variables['generator_name']);
                $sname_delimited = Glb_Text::delimit($variables['generator_short_name']);

                // complete variables
                foreach (['generator_name', 'generator_sname', 'generator_main_use_sing', 'generator_main_use_plur'] as $item) {
                    $variables[$item . '_delimited'] = Glb_Text::delimit($variables[$item]);
                    $variables[$item . "_lc_u"] = strtolower(Glb_Text::underscore($variables[$item . '_delimited']));
                    $variables[$item . "_uc_u"] = strtoupper(Glb_Text::underscore($variables[$item . '_delimited']));
                    $variables[$item . "_wc_u"] = ucwords(Glb_Text::underscore($variables[$item . '_delimited']), '-_');
                    $variables[$item . "_fwc_u"] = ucfirst(Glb_Text::underscore($variables[$item . '_delimited']));
                    $variables[$item . "_lc_s"] = strtolower(str_replace('-', ' ', $variables[$item . '_delimited']));
                    $variables[$item . "_uc_s"] = strtoupper(str_replace('-', ' ', $variables[$item . '_delimited']));
                    $variables[$item . "_wc_s"] = ucwords(str_replace('-', ' ', $variables[$item . '_delimited']), '-_');
                    $variables[$item . "_fwc_s"] = ucfirst(str_replace('-', ' ', $variables[$item . '_delimited']));
                    $variables[$item . "_lc_d"] = strtolower($variables[$item . '_delimited']);
                    $variables[$item . "_uc_d"] = strtoupper($variables[$item . '_delimited']);
                    $variables[$item . "_wc_d"] = ucwords($variables[$item . '_delimited'], '-_');
                    $variables[$item . "_fwc_d"] = ucfirst($variables[$item . '_delimited']);
                    $variables[$item . "_lc_sp"] = strtolower(str_replace('-', ' ', $variables[$item . '_delimited']));
                    $variables[$item . "_uc_sp"] = strtoupper(str_replace('-', ' ', $variables[$item . '_delimited']));
                    $variables[$item . "_wc_sp"] = ucwords(str_replace('-', ' ', $variables[$item . '_delimited']), '-_');
                    $variables[$item . "_fwc_sp"] = ucfirst(str_replace('-', ' ', $variables[$item . '_delimited']));
                }

                $variables['generator_current_year'] = date('Y');
                $variables['generator_current_date'] = date('Y-m-d');
                $variables['generator_current_datetime'] = date('Y-m-d H:i:s');
                $variables['generator_package'] = 'Gloubi_Boulga_' . str_replace(' ', '_', Glb_Text::humanize($variables['generator_name']));

                $stop = false;
                $generator_folder = Glb_Path::normalize($this->plugin->file_path('generator'));
                if (!file_exists($generator_folder)) {
                    $this->plugin->notices->add(__glb('Hmmm... can\'t find required folder « %s » !', $generator_folder), 'error');
                    $stop = true;
                }

                if (!$stop) {
                    $source_folder = Glb_Path::list_folders($generator_folder);
                    if (empty($source_folder[0])) {
                        $this->plugin->notices->add(__glb('Hmmm... generator folder « %s » is empty !', $generator_folder), 'error');
                        $stop = true;
                    } else {
                        $source_folder = $source_folder[0];
                    }
                }

                $target_folder = '';
                if (!$stop) {
                    $source_folder_name = Glb_Path::last_part($source_folder);
                    $replacements = Glb_Text::between_all($source_folder_name, '{{', '}}');
                    foreach($replacements as $replacement) {
                        if (!array_key_exists($replacement, $variables)) {
                            $this->plugin->notices->add(__glb('Hmmm... generator can\'t decipher variable « %s » !', $replacement), 'error');
                            $stop = true;
                        } else {
                            $target_folder = str_replace('{{' . $replacement . '}}', $variables[$replacement], $source_folder_name);
                            $target_folder = Glb_Path::normalize(WP_PLUGIN_DIR . GLB_SEPARATOR . $target_folder);
                        }
                    }
                }

                if (!$stop && file_exists($target_folder)) {
                    $this->plugin->notices->add(__glb('Not good... Something is already occupying folder « %s » ! Please change your plugin\'s name or remove the conflicting plugin.', $target_folder), 'error');
                    $stop = true;
                }

                // let's go guys
                if (!$stop) {

                    // copy folder
                    Glb_Path::copy_folder($source_folder, $target_folder);

                    // replace tags in files / folders names
                    $things = Glb_Path::list_all($target_folder, '*', true);
                    foreach($things as $thing) {
                        $replacements = Glb_Text::between_all($thing, '{{', '}}');
                        $new_thing = $thing;
                        if ($replacements) {
                            foreach($replacements as $replacement) {
                                if (!array_key_exists($replacement, $variables)) {
                                    $this->plugin->notices->add(__glb('Hmmm... generator can\'t decipher variable « %s » !', $replacement), 'error');
                                    $stop = true;
                                    break;
                                } else {
                                    $new_thing = str_replace('{{' . $replacement . '}}', $variables[$replacement], $new_thing);
                                }
                            }
                            rename($thing, $new_thing);
                        }
                        if ($stop) {
                            break;
                        }
                    }

                    // replace tags in files content
                    $things = Glb_Path::list_files($target_folder, '*', true);
                    foreach($things as $thing) {
                        $content = file_get_contents($thing);

                        foreach(['generator_database', 'generator_roles'] as $key) {
                            $replacements = Glb_Text::between_all($content, '<<' . mb_strtoupper($key), mb_strtoupper($key) . '>>');
                            if ($replacements) {
                                foreach($replacements as $replacement) {
                                    if (empty($variables[$key])) {
                                        $content = str_replace('<<' . mb_strtoupper($key) . $replacement . mb_strtoupper($key) . '>>', '', $content);
                                    } else {
                                        $content = str_replace('<<' . mb_strtoupper($key), '', $content);
                                        $content = str_replace(mb_strtoupper($key) . '>>', '', $content);
                                    }
                                }
                                file_put_contents($thing, $content);
                            }
                        }


                        $replacements = Glb_Text::between_all($content, '{{', '}}');
                        $replacements = Glb_Array::remove_value($replacements, ['ver', 'id', 'name']);
                        if ($replacements) {
                            foreach($replacements as $replacement) {
                                if (!array_key_exists($replacement, $variables)) {
                                    $this->plugin->notices->add(__glb('Hmmm... generator can\'t decipher variable « %s » !', $replacement), 'error');
                                    $stop = true;
                                    break;
                                } else {
                                    $content = str_replace('{{' . $replacement . '}}', $variables[$replacement], $content);
                                }
                            }
                            file_put_contents($thing, $content);
                        }
                        if ($stop) {
                            break;
                        }
                    }
                }

                if ($stop) {
                    // delete main folder
                }

                    /*
                    if (!$stop) {
                    }

                    $copy_folder = Glb_Path::normalize(WP_PLUGIN_DIR . GLB_SEPARATOR . 'gloubi-boulga-' . $variables['generator_sname_lc_d']);
                    // @todo : fill inputs with already submitted values
                    if (!file_exists($generator_folder)) {
                        $this->plugin->notices->add(__glb('Hmmm... can\'t find required folder « %s » !', $generator_folder), 'error');
                        //$this->plugin->request->redirect('referer');
                    } else if (file_exists($copy_folder)) {
                        $this->plugin->notices->add(__glb('Something is already occupying folder « %s » !', $copy_folder), 'error');
                        //$this->plugin->request->redirect('referer');
                    } else {
                        // everything is OK
                        var_dump('Copying from ' . $source_folder . ' to ' . $copy_folder);
                        $source = Glb_Path::list_folders($source_folder);
                        if (empty($source[0])) {
                            $this->plugin->notices->add(__glb(__glb('Hmmm... required folder « %s » is empty !', $source_folder)), 'error');
                        } else {
                            Glb_Path::copy_folder($root_folder, $copy_folder);
                        }
                    }*/

            }


               /*
               hmm... now, take the whole generator folder
               1/ copy everything to the new plugin folder
               2/ rename files and folders, replacing variables
               3/ open all files and replace variables
               */

               //Glb_Path::copy_folder($root_folder, $copy_folder);

        }

        $this->plugin->render_template('glb-core-admin-page', ['params' => $params]);
        // @todo : make plugin->render function
        //echo Glb_Path::get_include_content( $this->plugin->file_path('templates', 'glb-core-admin-page.php'), ['params' => $params] );
    }

    /*
     * @function render_notices : render pending notices
     * notices can be set before sending ajax response, so that notices wll be displayed on the next html page rendered
     * @todo : allow notices to be displayed via ajax
     */
    public function render_notices() {
        $this->notices->render();
    }

}
