(function( $ ) {
    'use strict';

	var glb_core_admin = {

        /*
        declare JS initializations here
        */
        init: function () {

            /*$('.xglb-select2').select2({
                    allowClear: true,
                    width: 'style',
                    //placeholder: "Choose manufacturers",
                }
            );*/
            /*glb_core_admin.update_visibility();*/
        },

        /*
        declare JS events here
        */
        events: function () {

            $("*[data-glb-toggle='source']").on('click', function( event ) {
                event.preventDefault();
                var target_selector = $(this).attr('data-glb-toggle-target');
                var display = $(this).attr('data-glb-toggle-display');
                var target = null;
                if ($(target_selector).length == 1) {
                    target = $(target_selector)[0];
                } else if ($(target_selector).length > 1) {
                    target = glb_core_admin.nearest(target_selector, $(this));
                }

                if (target !== null) {
                    var display_init = $(target).attr('data-glb-toggle-init');
                    if (!display_init) {
                        display_init = 'hidden';
                    }
                    var status = $(target).attr('data-glb-toggle-status');
                    if (!status) {
                        status = display_init;
                    }
                    console.log(status);
                    if (status == 'hidden') {
                        status = 'visible';
                        $(target).slideDown(200);
                    } else {
                        status = 'hidden';
                        $(target).slideUp(200);
                    }
                    $(target).attr('data-glb-toggle-status', status);
                    $(this).attr('data-glb-toggle-status', status);
                }

            });
                    // manage visibility using data-glb-visibility attribute
            $("*[data-glb-dependency]").each(function( index ) {
                var dependencies = $(this).data('glb-dependency');
                //dependencies = dependencies.split(',');
                //for (var i = 0; i < dependencies.length; i++) {
                //    dependencies = dependencies.trim
                //}
                console.log('events');
                console.log(dependencies);
                //for (var i = 0; i < dependencies.length; i++) {
                    console.log(dependencies);
                    $(dependencies).on('change', {dependencies: dependencies}, function(event) {
                        //event.preventDefault();
                        glb_core_admin.update_visibility($(this), event.data.dependencies);
                    });

                var value = true;
                console.log('init------- ' + dependencies);
                $(dependencies).each(function() {
                    if (glb_core_admin.empty_val($(this))) {
                        value = false;
                    }
                });
                console.log('init------- ' + value);
                if (!value) {
                    if ($(this).closest('tr').length) {
                        $(this).closest('tr').find('td, th').hide();
                    } else {
                        $(this).hide();
                    }
                } else {
                    console.log('value true');
                }
                //}
                console.log('---');
            });

            $('.admin-search-toggle').on('click', function(event) {
                event.preventDefault();
                $(this).parent().find('.admin-search-content').toggleClass('hidden');
            });

            $('tr.generator-database input[name="database"]').on('change', function(event) {
                if ($(this).is(':checked')) {
                    glb_core_admin.slide_tr($('tr.generator-main-use'), 'down', 150);
                } else {
                    glb_core_admin.slide_tr($('tr.generator-main-use'), 'up', 150);
                }
            });
        },

        slide_tr: function($tr, direction, speed) {

            $tr.find('th, td').each(function(index) {
                if (!$(this).find('div').length) {
                    $(this).wrapInner('<div></div>');
                }

                if (direction == 'up') {
                    $(this).slideUp(speed);
                    $(this).find('div').slideUp(speed);
                } else {
                    $(this).slideDown(speed);
                    $(this).find('div').slideDown(speed);
                }
            });
        },

        update_visibility: function ($source, dependencies) {
            console.log('update_visibility exec');
            console.log($source);
            console.log(dependencies);
            $('[data-glb-dependency="' + dependencies +'"]').each(function() {
                //console.log('x');
                console.log(dependencies);
                //console.log($source.val());
                //var val = glb_core_admin.value($source);

                var value = true;
                // il faut vérifier toutes les valeurs liées aux dependencies, pas seulement une
                $(dependencies).each(function() {
                    if (glb_core_admin.empty_val($(this))) {
                        value = false;
                    }
                });
                console.log('value ' + value);

                if (value) {
                    console.log('!empty');
                    if ($(this).closest('tr').length) {
                        console.log('tr');
                        glb_core_admin.slide_tr($(this).closest('tr'), 'down');
                    } else {
                        $(this).slideDown(150);
                    }
                } else {
                    if ($(this).closest('tr').length) {
                        glb_core_admin.slide_tr($(this).closest('tr'), 'up');
                    } else {
                        $(this).slideUp(150);
                    }
                }
            });
        },

        val: function($element) {
            if ($element.prop('tagName') == 'input' && ['radio', 'checkbox'].indexOf($element.attr('type'))) {
                console.log('checked ' + $element.is(':checked'));
                return $element.is(':checked');
            } else {
                return $element.val();
            }
        },
        empty: function(variable) {
            return typeof variable == 'undefined' || variable == null || variable == '' || variable == 0 || variable == '0';
        },
        empty_val: function($element) {
            var val = glb_core_admin.val($element);
            return glb_core_admin.empty(val);
        },
        nearest: function($selector, $element) {
            while (!$element.find($selector).length) {
                $element = $element.parent();
                if ($element.prop("tagName") == 'html') {
                    return null;
                }
            }
            if ($element.find($selector).length) {
                return $element.find($selector)[0];
            } else {
                return null;
            }
        }
    };

    $(document).ready(function() {
		glb_core_admin.init();
        glb_core_admin.events();
    });


})( jQuery );
