(function( $ ) {
    'use strict';


    var glb_core_public = {

        /*
        declare JS initializations here
        */
        init: function () {
        },

        /*
        declare JS events here
        */
        events: function () {

            /*
            forbif multiple form submit
            */
            /*$('body').on('submit', 'form', function(e) {
                var self = $(this);
                if (self.data('alreadySubmitted')) {
                    e.stopImmediatePropagation();
                    e.preventDefault();
                } else {
                    self.data('alreadySubmitted', true);
                }
            });*/


            /**
             * paging section -> adding perpage dropdown
             */
            $('select[name="per_page"]').on('change', function (event) {
                event.preventDefault();
                $(this).closest('form').submit();
            });

            $('.glb-select-preview').on('change', function(event) {
                event.preventDefault();
                var id = $(this).attr('id') + '-preview',
                    data = JSON.parse(atob($(this).data('glb-select-preview'))),
                    val = $(this).val();
                //console.log('.glb-select-preview:change ' + $(this).val());
                //var item = data[val];
                //console.log(item)
                //console.log(data);

                /*if (typeof data.$(this).val() != 'undefined') {

                }
                if ($('#' + id).length) {
                    $('#' + id).html('<div><img src="">')
                }*/

            });

            /**
             * glb-ajax behavior for clickable things
             */
            $('[data-glb-behavior="glb-ajax"]').on('click', function (event) {
                event.preventDefault();

                var $target = $(this);

                if ($(this).data('glb-confirm')) {
                    var confirm_args = JSON.parse(atob($(this).data('glb-confirm')));
                    glb_core_public.modal(confirm_args, $target.attr('href'), JSON.parse(atob($target.data('glb-behavior-args'))));
                } else {
                    glb_core_public.ajax($target.attr('href'), JSON.parse(atob($target.data('glb-behavior-args'))));
                }

            });

        },

        eval_if_nan: function(value) {
            if (value === false) {
                return false;
            } else if (value == "auto") {
                return 'auto';
            } else if (isNaN(value)) {
                return eval(value);
            } else {
                return value;
            }
        },

        /**
         @function serialize_object
         @param $form : form jquery element
         @return the same as form.serializeArray() but as key/value objects
         ( don't put this into $.fn for avoiding future evolutions of jQuery )
         */
        serialize_object: function($form) {
            var o = {};
            var a = $form.serializeArray();
            $.each(a, function() {
                /*if (o.hasOwnProperty(this.name)) {
                    if (!o[this.name].push) {
                        o[this.name] = [o[this.name]];
                    }
                    o[this.name].push(this.value || '');
                } else {
                    o[this.name] = this.value || '';
                }*/
                o[this.name] = this.value || '';
            });
            return o;
        },

        /**
         @function get_attr
         @param object : the object inside which to search for
         @param path : the path of the searched value
         @param def : the default value to return if nothing is found
         @return the value or default if nothing was found
         @example : glb_core_public.get_attr(my_array_or_object, 'key.subkey.finalsubkey') -> will search for (my_array_or_object['key']['subkey']['finalsubkey'])
         */
        get_attr: function (object, path, def) {
            var current = object;
            if (typeof def == 'undefined') {
                def = null;
            }
            if (typeof current == 'undefined') {
                return def;
            }
            var path_pieces = path.split('.');
            for (var i = 0; i < path_pieces.length; i++) {
                if (typeof current[path_pieces[i]] == 'undefined') {
                    return def;
                }
                current = current[path_pieces[i]];
            }
            return current;
        },

        /**
         @function modal : opens a modal with content obtained from submit_url with submit_args
         @param args : some interesting attributes, such as { 'title':  'my modal title', 'buttons': {'label': 'Yep, do it', 'action': 'submit-form'}, {'label': 'Nope, cancel', 'action': 'dismiss-modal'} }
         @param submit_url (optional) : the url where to go after the user has clicked on the OK button
         @param submit_args (optional) : the args associated to the previous URL
         @return void
         */
        modal: function (args, submit_url, submit_args) {

            console.log('modal ' + submit_url);
            console.log(args);
            console.log(submit_args);

            // create unique id
            var id = "glb-dialog-content-" + Date.now();

            // build dialog html
            var classes = (args['data-class'] ? args['data-class'] + ' ' : '') + ' glb-dialog-content';

            var $dialog = $('body').append('<div id="' + id + '" title="' + args['title'] + '"' + (classes ? ' class="' + classes + '" ' : '') + '>' + args['content'] + '</div>');
            console.log('---------');

            // build buttons
            var buttons_args = glb_core_public.get_attr(args, 'buttons', []);
            var buttons = [];
            console.log('------------');
            console.log(buttons_args);
            console.log(args);
            console.log(glb_confirm_ok);
            if (!buttons_args.length) {

                var label_ok = glb_core_public.get_attr(args, 'label_ok', glb_confirm_ok);
                var label_cancel = glb_core_public.get_attr(args, 'label_cancel', glb_confirm_cancel);
                buttons.push({
                    text: label_ok,
                    id: 'label_ok',
                    click: function (event) {
                        glb_core_public.ajax(submit_url, submit_args);
                        $(this).dialog("close");
                    }
                });
                buttons.push({
                    text: label_cancel,
                    id: 'label_cancel',
                    click: function (event) {
                        $(this).dialog("close");
                    }
                });

            } else {
                console.log('yes button args');
                console.log(buttons_args);

                for (var i = 0; i < buttons_args.length; i++) {
                    var button = {
                        text: buttons_args[i]['label'],
                        id: glb_core_public.get_attr(buttons_args, i + '.id', 'dialog-button-' + i),
                        'data-glb-action': buttons_args[i]['action'],
                        click: function (event) {
                            var $button = $(event.target).closest('button');
                            console.log('click');
                            console.log($button.attr('class'));
                            console.log($button.attr('data-glb-action'));
                            if ($button.attr('data-glb-action') == 'dismiss-modal') {
                                $(this).dialog("close");
                            } else if ($button.attr('data-glb-action') == 'submit-form') {
                                console.log($('#'.id).length);
                                if (!$('#' + id).find("form").length) {
                                    return;
                                }
                                var form_data = glb_core_public.serialize_object($('#' + id).find("form"));
                                console.log(form_data);
                                glb_core_public.ajax($('#' + id).find("form").attr('action'), form_data);
                                $(this).dialog("close");
                            }
                        }
                    };
                    buttons.push(button);
                }
            }

            $('#' + id).dialog({
                resizable: true,
                closeOnEscape: true,
                modal: true,
                height: glb_core_public.eval_if_nan(glb_core_public.get_attr(args, 'height', "auto")),
                width: glb_core_public.eval_if_nan(glb_core_public.get_attr(args, 'width', 400)),
                minHeight: glb_core_public.eval_if_nan(glb_core_public.get_attr(args, 'min-height', false)),
                minWidth: glb_core_public.eval_if_nan(glb_core_public.get_attr(args, 'min-width', false)),
                maxHeight: glb_core_public.eval_if_nan(glb_core_public.get_attr(args, 'max-height', false)),
                maxWidth: glb_core_public.eval_if_nan(glb_core_public.get_attr(args, 'max-width', false)),
                buttons: buttons,
            });
            $('#' + id).closest('.ui-dialog').addClass('glb-dialog');

            var width = $( '#' + id ).dialog( "option" );

            /*} else {

                var buttons = [];
                console.log('buttons');
                console.log(args['buttons'].length);
                var i;
                for (i = 0; i < args['buttons'].length; i++) {
                    console.log('i : ' + i);
                    var button = {
                        text: args['buttons'][i]['label'],
                        id: glb_core_public.get_attr(args, 'buttons.' + i + '.id', 'dialog-button-' + i),
                        'data-glb-action': args['buttons'][i]['action'],
                        click: function(event) {

                            if ($(event.target).parent('button').data('glb-action') == 'dismiss-modal') {

                                $(this).dialog("close");

                            } else if ($(event.target).parent('button').data('glb-action') == 'submit-form') {

                                console.log($('#' . id).length);
                                if (!$('#' + id).find("form").length) {
                                    return;
                                }

                                console.log('submit-form');
                                console.log(args);
                                console.log(submit_args);

                                var form_data = glb_core_public.serialize_object( $('#' + id).find("form") );
                                console.log('form_args');
                                console.log(form_data);

                                glb_core_public.ajax($('#' + id).find("form").attr('action'), form_data);
                                $(this).dialog("close");
                            }
                        }
                    };
                    buttons.push(button);
                    console.log(buttons);
                }*/


            // @todo remove modal html
        },


        /**
         @function ajax : process ajax requests
         @param hrefValue :
             @param data :
         @return void
         */
        ajax: function (hrefValue, data) {
            //console.log('ajax ' + hrefValue);
            //console.log(data);
            glb_core_public.loading(true);
            $.ajax({
                url: hrefValue,
                type: 'POST',
                dataType: 'json',
                data: data,
                success: function (data, textStatus, xhr) {
                    console.log('yeah...');
                    console.log(data);
                    console.log(textStatus);
                    console.log(xhr);
                    glb_core_public.ajax_response(data);
                },
                error: function (xhr, textStatus) {
                    console.log('error');
                    console.log(textStatus);
                    console.log(xhr);
                    if (xhr.responseJSON) {
                        glb_core_public.ajax_response(xhr.responseJSON);
                    } else if (xhr.responseText) {
                        glb_core_public.ajax_response(JSON.parse(xhr.responseText));
                    }
                },
                complete: function() {
                    glb_core_public.loading(false);
                }
            });
        },

        /**
         @function ajax_response : process ajax requests responses
         @param responseJson : the json response sent by the server
         @todo : describe all possibilities : actions.redirect, actions.modal, ....
         @return void
         */
        ajax_response: function (responseJson) {
            console.log('ajax_response');
            console.log(responseJson);
            //console.log(glb_core_public.get_attr(responseJson, 'actions.redirect'));
            //console.log(glb_core_public.get_attr(responseJson, 'actions.modal'));

            if (typeof responseJson != "undefined") {
                if (typeof responseJson.actions != "undefined") {
                    if (!Array.isArray(responseJson.actions)) {
                        responseJson.actions = [responseJson.actions];
                    }
                    for (var i = 0; i < responseJson.actions.length; i++) {
                        var type = glb_core_public.get_attr(responseJson, 'actions.' + i + '.type');
                        if (type == 'redirect') {
                            glb_core_public.loading(true);
                            window.location = responseJson.actions[i].value;
                            return;
                        } else if (type == 'modal') {
                            glb_core_public.modal(responseJson.actions[i].value);
                        }
                    }
                }
            }
        },

        loading: function (show) {
            if (show) {
                jQuery('<div class="glb-loader"></div>').appendTo("body");
            } else {
                jQuery('.glb-loader').remove();
            }
        },

    };

    $(document).ready(function() {
        glb_core_public.init();
        glb_core_public.events();
    });



})( jQuery );
