<?php

/*
 * Gloubi boulga's plugin settings file
 * Put here all that is not suitable to be updated from the interface
 * It will not be deleted or updated by any plugin update
*/

return [
    'logs' => [
        // log folder path, from gloubi core folder
        'path' => '/logs',
        // max file size
        'max_file_size' => 10000000,
        // max file count (if max is reached, then older files will be deleted)
        'max_file_count' => 10
    ],
    'cache' => [
        'root' => GLB_CORE_PATH . 'tmp/cache',
        'db_schema' => [
            'folder' => '/',
            'duration' => '+0 minutes',
        ],
        'db_variables' => [
            'folder' => '/',
            'duration' => '+0 minutes',
        ],
    ],
    'cron' => [
        // global gloubi cron frequency
        'frequency' => 'hourly',
        // additional schedules
        'schedules' => [
            'every2minutes' => [
                'interval' => 2 * 60,
                'display'  => __glb('Every 2 minutes'),
            ],
            'every5minutes' => [
                'interval' => 5 * 60,
                'display'  => __glb('Every 5 minutes'),
            ],
            'every30minutes' => [
                'interval' => 30 * 60,
                'display'  => __glb('Every 30 minutes'),
            ],
            'every7days' => [
                'interval' =>  7 * 24 * 60 * 60,
                'display'  => __glb('Every 7 days'),
            ],
            'every30days' => [
                'interval' => 30 * 24 * 60 * 60,
                'display'  => __glb('Every 30 days'),
            ],
        ],
    ]
];