<?php

class Glb_Column extends Glb_Entity
{

    /**
     * [REQUIRED] You must declare constructor and give some basic params
     * options : 'min_length' => 3, 'max_length' => 255, 'edit_as' => 'folder', 'view_as' => 'folder'
     */
    //function __construct($key, $type, $default = null, $label = null, $options = null)
    function __construct($name, $data_type, $label = null, $options = [])
    {
        //parent::__construct(['key' => $key, 'type' => $type, 'label' => $label, 'default' => $default, 'options' => $options]);
        parent::__construct(array_merge(['name' => $name, 'data_type' => $data_type, 'label' => $label], $options));
    }

    public function validate($value) {
        return Glb_Request::instance()->validate_input($this->data_type, $value, empty($this['values']) ? null : array_keys($this['values']));
    }
}
