<?php

/**
 * Class Glb_Entity : simple class extending ArrayObject
 */
/*class Glb_Entity extends ArrayObject
{

    function __construct($input, $flags = ArrayObject::STD_PROP_LIST|ArrayObject::ARRAY_AS_PROPS)
    {
        parent::__construct($input, $flags);
    }
}
*/


/* <!-- ArrayAccess implementation */
class Glb_Entity implements ArrayAccess {

    protected $_properties      = [];
    protected $_modified        = [];
    protected $_first_get       = false;
    protected $_first_set       = false;
    protected $_archivable      = true;

    const ARCHIVABLE_FALSE = false;
    const ARCHIVABLE_TRUE = true;
    const ARCHIVABLE_RESTORE = 0;

    function __construct($data = [], $_archivable = true) {
        $this->_archivable = $_archivable;
        Glb_Validator::check_value($data, 'empty', []);
        if ($data instanceof Glb_Entity) {
            $this->_properties = $data->to_array();
        } else {
            $this->_properties = $data;
        }
    }

    public function archivable($value = null) {
        static $last = '---';

        if ($value === null) {

            return $this->_archivable;

        } else {

            if ($value === self::ARCHIVABLE_FALSE) {
                $last = $this->_archivable;
                $this->_archivable = false;
            } else if ($value === self::ARCHIVABLE_TRUE) {
                $last = $this->_archivable;
                $this->_archivable = true;
            } else if ($value === self::ARCHIVABLE_RESTORE) {
                $this->_archivable = $last;
            }

            return $this;
        }

    }

    protected function _archive($action, $property, $value) {
        if ($this->_archivable) {
            if (!array_key_exists($property, $this->_modified)) {
                $this->_modified[$property] = [
                    'original' => array_key_exists($property, $this->_properties) ? $this->_properties[$property] : null,
                    'last' => array_key_exists($property, $this->_properties) ? $this->_properties[$property] : null,
                ];
            } else {
                $this->_modified[$property] = [
                    'last' => array_key_exists($property, $this->_properties) ? $this->_properties[$property] : null,
                ];
            }
        }
    }

    public function destroy() {
        unset($this->_properties);
        unset($this->_modified);
    }

    public function offsetSet($property, $value) {
        $this->__set($property, $value);
    }

    public function offsetExists($property) {
        return $this->exists($property);
    }

    public function offsetUnset($property) {
        $this->__unset($property);
    }

    public function offsetGet($property) {
        return $this->_get($property);
    }

    public function __unset ($property) {
        if (array_key_exists($property, $this->_properties)) {
            $this->_archive('unset', $property, null);
            unset($this->_properties[$property]);
        }
    }
    public function __isset($property) {
        return $this->exists($property);
    }

    public function __set ($property, $value) {

        $this->_check_access('set', $property, $value);

        if (is_null($property)) {
            $this->_properties[]= $value;
        } else {
            if (!$this->exists($property) || $this->_properties[$property] != $value) {
                $this->_archive('set', $property, $value);
                $this->_properties[$property] = $value;
            }
        }
    }

    public function exists($property) {
        $this->_check_access('get', $property);
        return array_key_exists($property, $this->_properties);
    }

    protected function _check_access($type, $property = null, $value = null) {

        $raised = false;
        $raised_access = (!$this->_first_get && !$this->_first_set);

        // update first to avoid recursive infinite loop
        if ($type == 'get' && !$this->_first_get) {
            $raised = 'get';
            $this->_first_get = true;
        }
        if ($type == 'set' && !$this->_first_set) {
            $this->_first_set = true;
            $raised = 'set';
        }

        // throw first get event
        if ($raised == 'get') {
            if ($raised_access) {
                $this->first_access('get', $property);
            }
            $this->first_get($property);
        } else if ($raised == 'set') {
            if ($raised_access) {
                $this->first_access('set', $property, $value);
            }
            $this->first_set($property, $value);
        }
    }

    protected function &_get($property) {

        //glb_dump(get_class($this) . ' : get : ' . $property);
        $this->_check_access('get', $property);
        if (method_exists($this, '_get_property')) {
            //glb_dump(get_class($this) . ':get: method_exists _get_property ' . $property);
            return $this->_get_property($property);
        }

        if (!$this->exists($property)) {
            // force to avoid php exception
            $this->_properties[$property] = null;
        }
        return $this->_properties[$property];
    }

    public function &__get($property) {
        return $this->_get($property);
    }

    public function clean() {
        $this->_modified = [];
    }

    /*
     * methods to be overwritten
     */
    public function first_get($property) {
        //glb_dump(get_class($this) . ':first_get');
    }

    public function first_set($property, $value) {
    }

    public function first_access($type, $property = null, $value = null) {
    }

    public function to_array() {
        return $this->_properties;
    }

    public function __debugInfo() {
        $this->_check_access('get');
        //glb_dump(get_class($this) . ':' . $this->_archivable);
        if ($this->_archivable) {
            foreach ($this->_modified as $key => $value) {
                $this->_modified[$key]['actual'] = array_key_exists($key, $this->_properties) ? $this->_properties[$key] : null;
            }
            if (!empty($this->_modified)) {
                return $this->_properties + [
                        '~is_modified' => true,
                        '~modified' => $this->_modified,
                    ];
            } else {
                return $this->_properties + ['~is_modified' => false];
            }
       } else {
            return $this->_properties;
        }
    }

    public function __toString() {
        return print_r($this->__debugInfo(), true);
    }

    public function is_modified() {
        return (!empty($this->_modified));
    }

    public function get_modified($property = null) {
        if ($property === null) {
            foreach ($this->_modified as $key => $value) {
                $this->_modified[$key]['actual'] = array_key_exists($key, $this->_properties) ? $this->_properties[$key] : null;
            }
            return $this->_modified;
        } else if (array_key_exists($property, $this->_modified)) {
            $this->_modified[$property]['actual'] = array_key_exists($property, $this->_properties) ? $this->_properties[$property] : null;
            return $this->_modified[$property];
        } else {
            return null;
        }
    }

    public function get_original($property) {
        if (array_key_exists($property, $this->_modified)) {
            return $this->_modified[$property]['original'];
        } else {
            return null;
        }
    }

    public function reset_archives() {
        $this->_modified = [];
        return $this;
    }

    /*public function get_original($property = null) {
        if ($property === null) {
            return $this->_original;
        } else if (array_key_exists($property, $this->_original)) {
            return $this->_original[$property];
        } else {
            return null;
        }
    }*/

}