<?php

final class Glb_File_Cache
{

    /**
     * [
     *      'path' => '.',
     *      'prefix' => 'file_cache_',
     *      'encoding' => 'serialize',
     *      'duration' => '+1 month',
     * ],
     *
     * @var array
     */
    public $name                        = '~default';
    public $path                        = null;

    private $_options                   = [];
    protected $_data                    = [];
    protected $_file                    = false;

    private static $_list               = [];
    private static $_default_options    = [
        'root'      => GLB_CORE_PATH . '/tmp/cache',
        'folder'    => '/',
        'prefix'    => '',
        'encoding'  => 'serialize',
        'duration'  => '+1 month',
    ];

    public function __construct($name, $options) {
        self::$_default_options['root'] = Glb_Path::normalize(self::$_default_options['root']);
        $this->_options = array_merge(self::$_default_options, $options);
        Glb_Path::ensure_folder($this->_options['root'], 0705);
        Glb_Path::ensure_htdeny($this->_options['root'], '2 days');
        $folder = Glb_Path::concat([$this->_options['root'], $this->_options['folder']]);
        Glb_Path::ensure_folder($folder, 0705);
        Glb_Path::ensure_htdeny($folder, '2 days');
        $this->name = $name;
        $this->path = Glb_Path::concat([$folder, (empty($this->_options['prefix']) ? '' : $this->_options['prefix'] . '_') . Glb_Text::underscore(strtolower($name))]);
        $this->load();
    }

    public function load() {

        $this->_data = [];
        $this->_file = false;

        if (!Glb_Path::is_older_than($this->path, $this->_options['duration'])) {
            $content = @file_get_contents($this->path);
            if (!empty($content)) {
                $this->_file = 1;
                $this->_data = $this->_decode($content);
            }
        } else {
            $this->_file = 0;
        }
    }

    public function save() {
        file_put_contents($this->path, $this->_encode($this->_data));
        $this->_file = true;
    }

    protected function _decode($string) {
        if ($this->_options['encoding'] == 'json') {
            return json_decode($string, true);
        } else {
            return unserialize($string);
        }
    }

    protected function _encode($data) {
        if ($this->_options['encoding'] == 'json') {
            return json_encode($data);
        } else {
            return serialize($data);
        }
    }

    public function data($data = null) {
        if (!empty($data)) {
            if (serialize($data) != serialize($this->_data)) {
                $this->_data = $data;
                $this->save();
            }
        }
        return $this->_data;
    }

    public function file_missing() {
        return ($this->_file === false);
    }

    public function file_too_old() {
        return ($this->_file === 0);
    }

    public function file_valid() {
        return ($this->_file === true);
    }

    public function is_empty() {
        return empty($this->_file) || empty($this->_data);
    }

    public static function get($name, $options) {
        if (empty(self::$_list[$name . '--' . print_r($options, true)])) {
            self::$_list[$name . '--' . print_r($options, true)] = new Glb_File_Cache($name, $options);
        }
        return self::$_list[$name . '--' . print_r($options, true)];
    }

}

