<?php

final class Glb_Log
{

    static $config = [
        'path' => '/logs',
        'max_file_size' => 10000000,
        'max_file_count' => 10
    ];


    /*
     * @function set_config : set configuration
     * @param array $config
     * @return void
     * @usage :
     *      Glb_Log::set_config([ 'max_file_size' => 10000000, 'max_file_count' => 10 ])
     */
    public static function set_config($config) {
        self::$config = $config;
    }

    /*
     * @function check_files : check if file needs to be archived, then rotate logs
     * @param string $file
     * @return void
     */
    private static function check_files($file) {

        if (file_exists($file) && @filesize($file) > self::$config['max_file_size']) {
            // backup file
            rename($file, $file . '.' . time());
            // check if there is not too much files
            $files = glob($file . '*.*', GLOB_BRACE);
            $files2 = [];
            if (count($files) > self::$config['max_file_count']) {
                foreach($files as $file_found) {
                    $files2[$file_found] = filectime($file_found);
                }
                asort($files2);
                foreach ($files2 as $file_found => $date) {
                    unlink($file_found);
                    unset($files2[$file_found]);
                    if (count($files2) <= self::$config['max_file_count']) {
                        break;
                    }
                }

            }
        }
    }

    /*
     * @function check_folder : check if folder and .htaccess exist
     * @param string $folder
     * @return void
     */
    private static function check_folder($folder) {
        Glb_Path::ensure_folder($folder, 0705);
        Glb_Path::ensure_htdeny($folder, '+1 day');
    }

    /*
     * @function write_file : revolutionary function that writes in a file. Enjoy...
     * @param string $file : the file to be writtent
     * @param string $message : the message to be writtent
     * @return void
     */
    public static function write_file($file, $message) {
        self::check_files($file);
        file_put_contents($file, $message, FILE_APPEND);
    }

    /*
     * @function log : log messages into file
     */
    public static function log($level, $message, $message2 = null, $message3 = null) {

        $glb_core = Glb_Plugin::get('glb-core');
        if (empty($glb_core)) {
            //throw new Exception('Gloubi boulga\'s core plugin not fully loaded yet. A Glb_Log instruction has been called too early, please fix this.' );
            return;
        }
        if (empty($glb_core->path) || empty($glb_core->settings)) {
            //throw new Exception('Gloubi boulga\'s core plugin not fully loaded yet. A Glb_Log instruction has been called too early, please fix this.' );
            return;
        }

        static $folder = null;
        if ($folder === null) {
            $folder = Glb_Path::normalize($glb_core->path . GLB_SEPARATOR . self::$config['path']);
            self::check_folder($folder);
        }

        if (is_array($message) || is_object($message)) {
            $message = print_r($message, true);
        }
        if ($message2 !== null) {
            $message .= ' :: ' . print_r($message2, true);
        }
        if ($message3 !== null) {
            $message .= ' :: ' . print_r($message3, true);
        }

        $t = microtime(true);
        $micro = sprintf("%03d",($t - floor($t)) * 1000);

        $level_setting = $glb_core->settings->get('log_level');
        $all_values = $level_setting['values'];
        $setting_value = $level_setting['value'];

        //self::write_file('d:\\temp\\toto.txt', 'all values ' . print_r($level_setting, true) . "\r\n");
        //self::write_file('d:\\temp\\toto.txt', '$level_setting ' . print_r($level_setting, true));
        //self::write_file('d:\\temp\\toto.txt', 'all values ' . print_r($all_values, true) . "\r\n");
        //self::write_file('d:\\temp\\toto.txt', 'all values ' . print_r(array_keys($all_values), true) . "\r\n");
        //self::write_file('d:\\temp\\toto.txt', 'all values ' . print_r($setting_value, true));

        if (empty($all_values)) {
            return;
        }
        $requested = array_search($level, array_keys($all_values));

        if (empty($setting_value)) {
            $minimum = 1;
        } else {
            $minimum = array_search($setting_value, array_keys($all_values));
        }

        if ($requested >= $minimum) {
            for ($i = $requested; $i >= $minimum; $i--) {
                $file = Glb_Path::concat([$folder, array_keys($all_values)[$i] . '.log']);
                self::write_file($file, date('Y-m-d H:i:s.'.$micro) . "\t" . $_SERVER['REMOTE_ADDR'] . "\t" . $level . "\t" . $message . PHP_EOL);
            }
        }
    }

    /*
     * @function notice : log messages into notice log file
     */
    public static function notice($message, $message2 = null, $message3 = null) {
        self::log('notice', $message, $message2, $message3);
    }

    /*
     * @function info : log messages into info log file
     */
    public static function info($message, $message2 = null, $message3 = null) {
        self::log('info', $message, $message2, $message3);
    }

    /*
     * @function warning : log messages into warning log file
     */
    public static function warning($message, $message2 = null, $message3 = null) {
        self::log('warning', $message, $message2, $message3);
    }

    /*
     * @function error : log messages into error log file
     */
    public static function error($message, $message2 = null, $message3 = null) {
        self::log('error', $message, $message2, $message3);
    }

    /*
     * @function trace : log messages into trace log file
     */
    public static function trace($message, $message2 = null, $message3 = null) {
        self::log('trace', $message, $message2, $message3);
    }

}