<?php

class Glb_Notices
{

    private static $_too_late = false;
    private static $_initialized = false;
    private static $_id = 'xxx';

    public static function initialize() {

        Glb_Session::start();
        if (!self::$_initialized) {
            self::$_initialized = true;
            add_action('admin_notices', function () {
                //Glb_Log::info('-> admin_notices too late ?');
                self::$_too_late = true;
                return null;
            });
        }
    }

    public static function instance() {
        self::$_id = Glb_Text::unique_id();
        self::initialize();
        static $instance = null;
        if ($instance === null) { $instance = new Glb_Notices(); }
        return $instance;
    }

    // add_notice
    public function add($message, $severity = 'info', $options = []) {
        if ( Glb_Request::instance()->is('ajax') || !self::$_too_late ) {
            //Glb_Log::info('ajax or not too late for ' . $message);
            Glb_Session::instance()->ensure('glb_notices', []);
            Glb_Session::instance()->append('glb_notices', ['severity' => $severity, 'message' => $message, 'options' => $options]);
        } else {
            //Glb_Log::info('too late or ajax for ' . $message);
            $this->_print_one(['severity' => $severity, 'message' => $message, 'options' => $options]);
        }
    }

    public function get() {
        return Glb_Session::instance()->get('glb_notices');
    }

    public function clear() {
        //Glb_Log::info('clear');
        Glb_Session::instance()->remove('glb_notices');
        Glb_Session::instance()->set('glb_notices', []);
    }

    /*
     * print one notice
     * @param array $notice ['severity' => 'info', 'message' => 'my message']
     */
    private function _print_one($notice)
    {
        /*Glb_dump("_print_one");
        echo '<pre>';
        debug_print_backtrace();
        echo '</pre>';*/
        echo '<div class="notice notice-' . $notice['severity'] . ' is-dismissible">';
        $escape = true;
        if (array_key_exists('escape', $notice)) {
            $escape =  !empty($notice['escape']);
        }
        if ($escape) {
            echo '<p>' . glb_esch($notice['message']) . '</p>';
        } else {
            echo '<p>' . $notice['message'] . '</p>';
        }
        echo '</div>';
    }

    /*
     * echo pending notices, using $this->notices->get() or Glb_Notices::instance()->get()
     */
    public function render()
    {

        if( !session_id()) {
            session_start();
        }
        //Glb_Log::info($this->get());
        if (Glb_Request::instance()->is('ajax')) { return; }

        if (!empty($notices = $this->get())) {
            foreach ($notices as $notice) {
                add_action('admin_notices', function () use ($notice) {
                    //Glb_Log::info('-> admin_notices render ' . print_r($notice, true));
                    $this->_print_one($notice);
                });
            }
        }

        $this->clear();

        //Glb_Log::info("clear ", $this->get());

    }
}