<?php

/*
 * Glb_Table class.
 */

class Glb_Behavior
{

    protected $_options = [];
    protected $_default_options = [];

    function __construct($options) {
        $this->_options = array_merge($this->_default_options, $options);
    }

    protected function _check_field($field, $table) {
        return (!empty($this->_options[$field]) && $table->has_column($this->_options[$field]));
    }

    /**
     * All availabe methods to be overwritten by custom behaviors
     * @param Glb_Query $query
     * @param array $context
     * @param array $options
     */
    public function before_select($query, $context, $options) {

    }

    public function after_select($query, $context, $options) {

    }

    public function before_update($entity, $context, $options) {

    }

    public function after_update($entity, $context, $options) {

    }

    public function before_insert($entity, $context, $options) {

    }

    public function after_insert($entity, $context, $options) {

    }

    public function before_delete($entity, $context, $options) {

    }

    public function after_delete($entity, $context, $options) {

    }

}