<?php

/*
 * Glb_Table class.
 */

class Glb_Schema
{

    private $_cache = null;
    private $_tables = [];
    private $db = null;

    function __construct($database, $settings = ['duration' => '+1 year', 'folder' => '/']) {
        $this->db = Glb_Db::instance();
        $this->_cache = Glb_File_Cache::get('schema_' . $database, $settings);
        if ($this->_cache->is_empty()) {
            $this->_tables = $this->_load_database($database);
            $this->_cache->data($this->_tables);
        }
        $this->_tables = $this->_cache->data();
    }

    protected function _load_database($database) {
        $sql = 'SHOW TABLES FROM ' . $database;
        $tables = Glb_Db::instance()->raw_query($sql, [], false, ARRAY_N);
        $result = [];
        foreach($tables as $table) {
            $revert = $this->db->table_name_revert($table[0]);
            $result[$revert] = [
                'name' => $revert,
                'real_name' => $table[0],
                'attributes' => []
            ];
            $sql = 'SHOW TABLE STATUS WHERE Name="' . $table[0] . '"';
            $table_infos = Glb_Db::instance()->raw_query($sql, [], false, ARRAY_A);
            foreach($table_infos as $table_info) {
                foreach ($table_info as $key => $value) {
                    $result[$revert]['attributes'][strtolower($key)] = $value;
                }
            }
            $result[$revert]['indexes'] = $this->_load_table_indexes($table[0]);
            $result[$revert]['columns'] = $this->_load_table_columns($table[0]);
        }
        return $result;
    }

    protected function _load_table_columns($table) {
        $sql = "DESCRIBE $table";
        $cols = Glb_Db::instance()->raw_query($sql, []);
        $results = [];
        foreach ( $cols as $col_data ) {
            $results[$col_data['Field']] = new Glb_Schema_Column($table, $col_data);
        }
        return $results;
    }

    protected function _load_table_indexes($table) {
        $sql = "SHOW INDEXES FROM $table";
        $indexes = Glb_Db::instance()->raw_query($sql, []);
        $results = [];
        foreach ( $indexes as $index_data ) {
            Glb_Array::ensure_key($results, $index_data['Key_name'], []);
            $results[$index_data['Key_name']][$index_data['Column_name']] = $index_data;
            $results[$index_data['Key_name']][$index_data['Column_name']] = Glb_Hash::lowerize_keys($results[$index_data['Key_name']][$index_data['Column_name']]);
        }

        return $results;
    }

    /**
     * first find raw name, then $table_name without glb_ prefix, then $table_name with glb_prefix
     * @param $table_name
     */
    public function find_best($table_name) {

        $names = [ Glb_Text::ensure_leading($table_name, 'glb_'), Glb_Text::remove_leading($table_name, 'glb_') ];
        foreach($names as $name) {
            if (in_array($name, array_keys($this->_tables))) {
                return $this->_tables[$name];
            }
        }
        return false;
    }

    /*public function tables($table_names) {
        if (empty($table_names)) {
            return $this->_tables;
        } else {
            return Glb_Array::extract_keys($this->_tables, $table_names);
        }
    }*/

    public function table($table_name) {
        if (array_key_exists($table_name, $this->_tables)) {
            return $this->_tables[$table_name];
        } else {
            return null;
        }
    }

    public function table_exists($table_name) {
        return ($this->table($table_name) !== null);
    }

    public function columns($table, $column_names = null) {
        $table_item = $this->table($table);
        if ($table_item === null) {
            return null;
        } else {
            if ($column_names === null) {
                return $table_item['columns'];
            } else {
                return Glb_Array::extract_keys($table_item['columns'], $column_names);
            }
        }
    }

    public function column($table, $column_name) {
        $table_item = $this->tables($table);
        if ($table_item === null) {
            return null;
        } else {
            $table_item['columns'][$column_name];
        }
    }

    public function column_exists($table, $column) {
        return !empty($this->columns($table, [$column]));
    }

}