<?php


/**
* between scripts and styles, difficult to choose... pfff... too lazy !
*/
class Glb_Plugin_Scryptles
{

    //protected $scripts;
    private $plugin;
    private $type;
    private $items = [];
    private $pending = [];
    private $enqueued = false;

    function __construct($type, $plugin) {
        $this->type = $type;
        $this->plugin = $plugin;
        $this->plugin->add_action('wp_enqueue_scripts', [$this, 'enqueue_public']);
        $this->plugin->add_action('admin_enqueue_scripts', [$this, 'enqueue_admin']);
    }

    /**
     * @function register : register scripts or styles to be enqueued at the good moment
     * @param $items : array of scryptles to enqueue
     */
    public function register($items) {
        if ($this->enqueued) {
            throw new Exception(__('Too late Buddy, scripts have already been enqueued !'));
        }
        if (empty($items)) { return; }
        $this->pending = array_merge($this->pending, $items);
    }

    /*
     * @function enqueue_admin
     * enqueue all loaded scryptles, at 'admin_enqueue_scripts' action
     * 'wp_enqueue_s****' must be done here because of WP specifications
     */
    public function enqueue_admin() {
        $this->enqueued = true;
        $this->enqueue('admin');
    }

    /*
     * @function enqueue_admin
     * enqueue all loaded scryptles, at 'wp_enqueue_scripts' action
     * 'wp_enqueue_s****' must be done here because of WP specifications
     */
    public function enqueue_public() {
        $this->enqueued = true;
        $this->enqueue('public');
    }


    /*
     * @function enqueue
     * enqueue all loaded scryptles, at 'wp_enqueue_scripts' action
     * 'wp_enqueue_s****' must be done here because of WP specifications
     */
    private function enqueue($source) {
        foreach ($this->pending as $itemIndex => $item) {
            if ( ($normalized = $this->normalize($item)) !== false) {
                $this->items[] = $normalized;
            }
        }

        foreach ($this->items as $item) {

            if (!in_array($source, $item['render'])) {
                continue;
            }

            // check version using $wp_scripts (example $item['ver'] = "jquery-ui-core")
            if (!empty($item['ver']) && !empty($item['src']) && !is_numeric(str_replace('.', '', $item['ver']))) {
                global $wp_scripts;
                if (!empty($wp_scripts->registered[$item['ver']]) && !empty($wp_scripts->registered[$item['ver']]->ver)) {
                    $item['ver'] = $wp_scripts->registered[$item['ver']]->ver;
                }
            }

            // replace {{ver}} keyword in src
            if (!empty($item['src'])) {
                $item['src'] = str_replace('{{ver}}', empty($item['ver']) ? '' : $item['ver'], $item['src']);
            }
            //var_dump($item);

            if ($this->type == 'styles') {
                wp_enqueue_style($item['handle'], (empty($item['src']) ? null : $item['src']), $item['deps'], (empty($item['ver']) ? null : $item['ver']), $item['media']);
            } else if ($this->type == 'scripts') {
                wp_enqueue_script($item['handle'], (empty($item['src']) ? null : $item['src']), $item['deps'], (empty($item['ver']) ? null : $item['ver']), $item['in_footer']);
            }
        }
    }

    /**
     * @function normalize : normalize the scryptle item
     * @param $item : scryptle item
     * @return bool|mixed
     */
    private function normalize($item) {

        //var_dump($this->type);
        if (!empty($item['conditions'])) {

            if (is_callable($item['conditions'])) {

                if (!$item['conditions']()) {
                    return false;
                }

            } else if (is_string($item['conditions'])) {

                if (($result = Glb_Request::instance()->check_conditions($item['conditions'])) === false) {
                    return false;
                } else {
                    $item['render'] = $result;
                }
            }
        } else {
            $item['render'] = ['admin', 'public'];
        }

        if (empty($item['handle'])) {
            $item['handle'] = Glb_Text::slug($this->plugin->key . '-' . Glb_Path::get_path_info($item['src'], 'filename'));
        }

        $item = Glb_Hash::ensure_values($item, ['deps', 'media', 'in_footer'], [null, 'all', false]);

        if (!empty($item['src'])) {

            if (!Glb_Text::starts_with($item['src'], 'http') && !Glb_Text::starts_with($item['src'], '//')) {

                // prefer glb_core file
                $core_src = Glb_Path::concat([Glb_Plugin::get_registered('glb-core')->path, $item['src']]);
                if (!empty($item['ver'])) {
                    $core_src = str_replace('{{ver}}', $item['ver'], $core_src);
                }
                if (file_exists($core_src)) {
                    $item['src'] = Glb_Path::concat([Glb_Plugin::get_registered('glb-core')->wp_uri, $item['src']], ['type' => 'uri']);
                } else {
                    $item['src'] = Glb_Path::concat([$this->plugin->wp_uri, $item['src']], ['type' => 'uri']);
                }

            } else {

                if (!empty($item['local'])) {
                    if (file_exists($this->plugin->file_path($item['local']))) {
                        $item['src'] = $item['local'];
                    }
                }
            }

        }

        // force glb plugin version for refreshing the scripts of needed
        if (empty($item['ver']) && Glb_Text::starts_with($item['handle'], 'glb-')) {
            $item['ver'] = $this->plugin->version;
        }

        return $item;

    }

}
