<?php

class Glb_Plugin_Setting extends Glb_Column
{

    /**
     * Glb_Plugin_Setting constructor.
     * @param $name
     * @param $type
     * @param null $default
     * @param null $label
     * @param null $options
     */
    function __construct($name, $type, $label = null, $options = []) {
        parent::__construct($name, $type, $label, $options);
    }

    /**
     * @function html : returns admin html for the setting
     * @param string $type : can be 'input', 'label', or 'description'
     * @param array $attr : attribute for the main tag
     * @param array $options : options for displaying
     * @return string : the html to display
     */
    public function html($type = 'input', $attrs = [], $options = []) {

        if ($type == 'input') {
            if (empty($this['template'])) {
                $this['template'] = Glb_Html::find(Glb_Hash::merge($attrs, $this));
            }
            return Glb_Html::get($this['template'])->html($this, $attrs, $options);
        }
        if ($type == 'label' && !empty($this['label'])) {
            return Glb_Html::get('label')->html($this, $attrs, $options);
        }
        if ($type == 'description' && !empty($this['description'])) {
            return Glb_Html::get('description')->html($this, $attrs, $options);
        }
        return '';
    }

    /**
     * @function validate : validates the value for this settings, according to his type
     * @param $value : the value to validate
     * @return bool : true if value is validated, false otherwise
     */
    public function validate($value)
    {
        if (!current_user_can('manage_options')) {
            return false;
        }
        return parent::validate($value);
    }

}
