<?php


class Glb_Plugin_Settings
{

    // the settings objects
    protected $items;
    protected $plugin;

    function __construct($plugin) {
        $this->plugin = $plugin;
        $this->items = [];
    }

    /*
     * @function load_settings : if $_settings is set in plugin, then it will be loaded here
     */
    public function load($settings) {

        if (empty($settings)) {
            return;
        }

        foreach($settings as $setting_name => $setting_attrs) {

            // make 'description' translatable
            if (!empty($setting_attrs['description'])) {
                if (is_array($setting_attrs['description'])) {
                    echo print_r($setting_attrs, true);
                    $setting_attrs['description'] = __glb($setting_attrs['description'][0], $setting_attrs['description'][1]);
                } else {
                    $setting_attrs['description'] = __glb($setting_attrs['description']);
                }
            }

            // normalize and make 'values' translatable
            if (!empty($setting_attrs['values'])) {
                $normalized_values = [];
                $is_associative = Glb_Array::is_associative($setting_attrs['values']);
                foreach($setting_attrs['values'] as $value_key => $value) {
                    if (!$is_associative) {
                        $normalized_values[$value] = __glb($value);
                    } else {
                        $normalized_values[$value_key] = __glb($value);
                    }
                }
                $setting_attrs['values'] = $normalized_values;
            }

            $setting = new Glb_Plugin_Setting(
                $setting_name,
                $setting_attrs['data_type'],
                __glb($setting_attrs['label']),
                $setting_attrs
            );

            $setting->value = Glb_Db::instance()->select_val('glb_core_settings', 'value', 'plugin = %s AND name = %s', [$this->plugin->key, $setting_name]);

            // set default value if settings have never been registerd
            if ($setting->value === null) {
                $setting->value = Glb_Hash::get($setting_attrs, 'default');
            }

            $this->items[$setting->name] = $setting;
        }
    }

    public function get($name = null, $default = null) {
        if ($name === null) {
            return $this->items;
        } else {
            if (!$this->exists($name)) {
                return $default;
            } else {
                return $this->items[$name];
            }
        }
        return $default;
    }

    public function get_value($name, $default = null) {
        if (!$this->exists($name)) {
            return $default;
        } else {
            return $this->items[$name]->value;
        }
        return $default;
    }

    public function get_values($names, $default = null) {
        $result = [];
        foreach($names as $name) {
            $result[$name] = $this->get_value($name, $default);
        }
        return $result;
    }

    public function exists($name) {
        return array_key_exists($name, $this->items);
    }

    function set_value($name, $value, $save_to_db = true) {

        Glb_Log::info('set_value setting ', $name, $value);

        if (!$this->exists($name)) {
            Glb_Log::warning('Setting not found : ', $name, $value);
            return false;
        }

        $this->items[$name]['old_value'] = $this->get_value($name);
        if ($this->items[$name]['old_value'] == $value) {
            Glb_Log::notice('Setting not changed : ', $name, $value);
            return false;
        }

        if (!$this->items[$name]->validate($value)) {
            Glb_Db_Log::instance()->log('setting_save', 'admin_action', [__glbr('Setting input validation failed [%s = %s]'), [$name, $value]], null, 'error');
            return false;
        }

        $this->items[$name]->value = $value;
        if ($save_to_db) { $this->save($name); }

        return $this;
    }

    public function save($name = null) {

        //@todo verify setting type
        if ($name !== null) {
            Glb_Db::instance()->update_or_insert('glb_core_settings', ['value' => $this->items[$name]->value], ['plugin' => $this->plugin->key, 'name' => $name]);
            Glb_Db_Log::instance($this->plugin)->log('setting_save', 'admin_action',
                [__glbr('Setting « %s » updated'), $name],
                [__glbr('Old value : %s {{nl}}New value : %s'), [
                    empty($this->items[$name]->old_value) ? '' : $this->items[$name]->old_value,
                    empty($this->items[$name]->value) ? '' : $this->items[$name]->value]
                ],
                'info'
            );

        } else {
            foreach($this->items as $item) {
                Glb_Db::instance()->update_or_insert('glb_core_settings', ['value' => $item->value], ['plugin' => $this->plugin->key, 'name' => $item->name]);
                Glb_Db_Log::instance($this->plugin)->log('setting_save', 'admin_action',
                    [__glbr('Setting « %s » updated'), $name],
                    [__glbr('Old value : %s {{nl}}New value : %s'), [
                        empty($this->items[$name]->old_value) ? '' : $this->items[$name]->old_value,
                        empty($this->items[$name]->value) ? '' : $this->items[$name]->value
                        ]
                    ],
                    'info'
                );
            }
        }
    }

    /*
     * @function patch_and_save : get data from post query, validate it, and save to database
     * @return array $settings
     *
     */
    public function patch_and_save() {

        // save settings if needed
        foreach($this->items as $setting) {
            if ($this->plugin->request->get_post($setting->name) !== null) {
                //Glb_Log::info('saving setting ', $setting, $this->plugin->request->get_post($setting->name));
                $this->set_value($setting->name, $this->plugin->request->get_post($setting->name));
            } else {
                Glb_Log::info('not saving setting ', $setting, $this->plugin->request->get_post($setting->name));
            }
        }
        return $this->items;
    }

}
