<?php

use PHPUnit\Framework\TestSuite;

class Glb_Plugin_Unit_Tester {

    private $plugin = null;
    private $classes = [];
    private $results = [];

    public function __construct($plugin) {
        $this->plugin = $plugin;
        $testsPath = $this->plugin->file_path('tests');
        glb_dump($testsPath);
        $files = Glb_Path::list_files($testsPath, '*-tests.php');

        // load classes names
        foreach($files as $file) {
            $classes_before = get_declared_classes();
            require_once $file;
            $diff = array_diff(get_declared_classes(), $classes_before);
            $diff = array_filter($diff, function($item) {
                return Glb_Text::starts_with($item, 'Glb_');
            });
            $this->classes = array_merge($this->classes, $diff);
        }
    }

    public function run() {

        //var_dump(Glb_Path::list_folders('D:\Rouz_Perso\Rouz\Kerius\svn\kf-christophe\Gloubi-boulga\wordpress\wp-content\plugins\gloubi-boulga\tests\~path-tests', 'f*1', true));
        //var_dump(Glb_Path::list_files('D:\Rouz_Perso\Rouz\Kerius\svn\kf-christophe\Gloubi-boulga\wordpress\wp-content\plugins\gloubi-boulga\tests\~path-tests', '*', true));
        $this->results = [];
        foreach($this->classes as $class) {
            $this->results[$class] = [];
            $suite = new TestSuite($class);
            $results = $suite->run();
            $this->results[$class] = $this->normalize_results($results, $class);
        }

        return $this->results;

    }

    private function normalize_results($results, $class) {

        $return = [];

        foreach(['failures', 'errors', 'warnings', 'passed', 'skipped', 'risky'] as $type) {

            $typed_results = Glb_Hash::get_stuff($results, $type);
            if (empty($typed_results)) { continue; }

            foreach ($typed_results as $result_key => $result) {

                // passed results don't have description contents
                if ($type == 'passed') {
                    // this is an alert be cause there is no test in testCase
                    if (empty($result['message']) && $result['size'] == -1 && $result_key == 'PHPUnit\Framework\WarningTestCase::Warning') {
                        continue;
                    }
                    $test_name = $result_key;
                } else {
                    $test_name = Glb_Hash::get_stuff($result, 'getTestName');
                }

                // if an exception is raised during compilation
                $test_message = Glb_Hash::get_stuff($result, 'failedTest.getMessage');
                if ($file = Glb_Hash::get_stuff($result, 'thrownException.getFile')) {
                    $line = Glb_Hash::get_stuff($result, 'thrownException.getLine');
                    $file = Glb_Text::concatenate(':', $file, $line);
                }
                // if a test error is detectedserializableTrace
                $details = $this->exception_details($result);
                $exploded = Glb_Text::explode_nl(Glb_Hash::get_stuff($result, 'exceptionMessage'));
                //Glb_Log::info('trace exc ', Glb_Hash::get_stuff($result, 'thrownException.getTrace'));
                //glb_dump(Glb_Hash::get_stuff($result, 'thrownException'));
                if (in_array($type, ['errors'])) {
                    $stack = Glb_Array::get_stack(Glb_Hash::get_stuff($result, 'thrownException.getTrace'));
                    $exploded = array_merge($exploded, $stack);
                }
                if ($file) { $exploded[] = $file;}

                if (!array_key_exists($type, $return)) {
                    $return[$type] = [];
                }

                //Glb_Log::info('$test_message ', $test_message);
                //Glb_Log::info('$exploded ', $stack);
                $return[$type][] = [
                    'name' => str_replace($class . '::', '', $test_name),
                    'main_message' => $test_message,
                    'description' => ($type == 'passed') ? __glb('OK') : (!empty($exploded[0]) ? $exploded[0] : ''),
                    'message' => ($type == 'passed') ? '' : (in_array($type, ['errors']) ? $exploded : (!empty($exploded[1]) ? $exploded[1] : '')),
                    'details' => ($type == 'passed') ? null : $details,
                ];
            }

        }

        return $return;
    }

    public function exception_details($result) {

        $expected = $actual = $exception_string = '';
        $failure = Glb_Hash::get_stuff($result, 'thrownException.getComparisonFailure');
        if (!empty($failure)) {
            $expected = Glb_Hash::get_stuff($failure, 'getExpectedAsString');
            if (empty($expected)) { $expected = $this->primitive_as_string($failure->getExpected()); }
            $actual = Glb_Hash::get_stuff($failure, 'getActualAsString');
            if (empty($actual)) { $expected = $this->primitive_as_string($failure->getActual()); }
        }
        return ['expected' => $expected, 'actual' => $actual];

    }

    private function primitive_as_string($value) {
        if ($value === null) {
            return 'null';
        }

        if (is_bool($value)) {
            return $value ? 'true' : 'false';
        }

        if (is_scalar($value)) {
            return \print_r($value, true);
        }

        return null;
    }

}
