<?php
/**
 * Gloubi Boulga Array Utility : a set of very dramatically usefull static functions
 */

/**
 */
class Glb_Array
{

    /*
     * Ensure that a variable is an array. If not, convert it to.
     * @param mixed $array $var The variable to evaluate
     * @return void The variables are modified by reference
     */
    public static function ensure(&$var1, &$var2 = null, &$var3 = null, &$var4 = null, &$var5 = null)
    {
        if ($var1 !== null && !is_array($var1)) {
            $var1 = [$var1];
        }
        if ($var2 !== null && !is_array($var2)) {
            $var2 = [$var2];
        }
        if ($var3 !== null && !is_array($var3)) {
            $var3 = [$var3];
        }
        if ($var4 !== null && !is_array($var4)) {
            $var4 = [$var4];
        }
        if ($var5 !== null && !is_array($var5)) {
            $var5 = [$var5];
        }
    }

    /*
     * Ensure that an array variable contains a key. If not, create the key with $default.
     * @param array $var The variable to evaluate
     * @param string $key The key to search for
     * @param mixed $default The default value to set
     * @return array The array, completed with $key if needed
     */
    public static function ensure_key(&$var, $key, $default = [])
    {
        if ($var === null) return null;
        if (!is_array($var)) { return $var; }
        if (!array_key_exists($key, $var)) {
            $var[$key] = $default;
        }
        return $var;
    }

    public static function ensure_keys(&$var, $key, $default)
    {
        if ($var === null) return null;
        if (!is_array($var)) { return $var; }
        foreach($var as $var_key => $var_value) {
            if (!array_key_exists($key, $var[$var_key])) {
                $var[$var_key][$key] = $default;
            }
        }

        return $var;
    }

    /**
     * Get array nested level
     */
    public static function nested_level($array, $start = 0) {
        if (!is_array($array)) { return $start; }
        $start++;
        $levels = [];
        foreach($array as $key => $value) {
            $levels[] = self::nested_level($value, $start);
        }
        return max($levels);
    }

    /**
     * @function merge_if : merge onlye if $condition is true
     * @param array $array
     * @param $condition
     * @param array $merge_with
     * @return array
     */
    public static function merge_if($array, $condition, $merge_with = [])
    {
        if ($condition) {
            return array_merge($merge_with, $array);
        } else {
            return $array;
        }
    }

    /*
     * @function is_associative : test if an array is associatively designed
     * @param $array : the array to evaluate
     * @return bool : true if array is associative, false if incremental
     * @usage :
     *      is_associative( ['mum', 'dad', 'postman'] ) returns false
     *      is_associative( ['mum' => 'female', 'dad' => 'male', 'postman' => 'we dont know'] ) returns true
     */
    public static function is_associative($array)
    {
        if (empty($array)) return false;
        if (!is_array($array)) return false;
        return array_keys($array) !== range(0, count($array) - 1);
    }

    /*
     * @function convert_associative : convert array to associative array
     * @param array $array : the array to convert
     * @param array $default : the default value. If null, then set the key in the value
     * @return array : the converted array
     * @usage :
     *      convert_associative( ['mum', 'dad', 'postman'], null ) returns ['mum' => 'mum', 'dad' => 'dad', 'postman' => 'postman']
     *      convert_associative( ['mum', 'dad', 'postman'], [] ) returns ['mum' => [], 'dad' => [], 'postman' => []]
     *      convert_associative( ['mum', 'dad', 'postman' => ['weird', 'thing']], [] ) returns ['mum' => [], 'dad' => [], 'postman' => ['weird', 'thing']]
     */
    public static function convert_associative($array, $default = null)
    {
        /*$result = [];
        if (empty($array)) return [];
        if (!self::is_associative($array)) {
            foreach ($array as $value) {
                $result[$value] = $value;
            }
            return $result;
        }
        return $array;*/
        $result = [];
        if (empty($array)) return [];
        foreach ($array as $key => $value) {
            list($key2, $value2) = self::refind_key_value($key, $value, ($default === null ? $value : $default));
            $result[$key2] = $value2;
        }
        return $result;

    }


    /**
     * Little function to check if $key is int.
     * If it is then, returns [$value, $default].
     * If not, return [$key, $value]
     * Usefull for functions that allow arrays with associative and incremental items ['toto', 'titi' => ['tata']]
     * @param $key
     * @param $value
     * @param array $default
     * @return array
     * @usage :
     *  Glb_Array::refind_key_value('key', 'value', [])
     *      returns ['toto' => 'value']
     *  Glb_Array::refind_key_value(5, 'value', [])
     *      returns ['value' => []]
     *
     */
    protected static function refind_key_value($key, $value, $default = []) {
        if (is_int($key)) {
            return [$value, $default];
        } else {
            return [$key, $value];
        }
    }

    /**
     * Explode a string ensuring the number of items,
     * and pushing the found results to the end if not enough items found.
     * @param $delimiter
     * @param $string
     * @param $count Exact return count
     * @return array
     * @usage :
     *      Glb_Array::explode_nudge('my_table.my_field', '.', 2) returns ['my_table', 'my_field']
     *      Glb_Array::explode_nudge('my_field', '.', 2) returns [null, 'my_field']
     *      Glb_Array::explode_nudge('my_field', '.', 3, 'x') returns ['x', 'x', 'my_field']
     */
    /**
     */
    public static function explode_nudge($string, $delimiter, $count = null, $default = null) {
        $array = explode($delimiter, $string, $count);
        while (count($array) < $count) {
            array_unshift($array, $default);
        }
        return $array;
    }


    /*
     * @function explode_fractaly : explode with multiple imbricated separators
     * @param string $string : the string to explode
     * @param array $delimiters : the separators that will be used for explosion
     * @param boolean $trim [optional] : if true, all values with be trimmed before return
     * @param boolean $all_results_as_array [optional] : if true, all found values will be returned as array, including single values
     * @return array : a complex array of imbricated explodede things
     * @usage :
     *      explode_fractaly('big bang | boung & blur | bong', ['|', '&'], false, true) will return ['big bang', ['boung', 'blur'], 'bong']
     *      explode_fractaly('big bang | boung & blur | bong', ['|', '&'], true, true) will return [['big bang'], ['boung', 'blur'], ['bong']]
     *      explode_fractaly('home back next | open close | quit', ['|', ' ']) will return ['big bang', ['boung', 'blur'], 'bong']
     *      explode_fractaly('big bang | boung bung | bawg & boing | bouing bawn&boing bounx', ['|', ' ', '&'])
     *              will return [["big","bang"],["boung","bung"],{"bawg", "boing"},["bouing",["bawn","boing"],"bounx"]]
     * @notice : you can try to use $trim = false... and you'll tell me.
     */
    public static function explode_fractaly($string, $delimiters, $all_results_as_array = true, $trim = true)
    {

        $delimiter = array_shift($delimiters);
        $results = explode($delimiter, $string);
        if ($trim) {
            $results = array_map('trim', $results);
        }

        foreach ($results as $resultKey => $result) {
            if (count($delimiters) > 0) {
                $results[$resultKey] = self::explode_fractaly($result, $delimiters, $all_results_as_array, $trim);
            }
        }

        if (count($results) == 1 && !$all_results_as_array) {
            $results = $results[0];
        }
        if (is_array($results)) {
            return array_filter($results);
        } else {
            return $results;
        }

    }

    /*
     * @function explode_multiple : explode with multiple delimiters
     * @usage : ('big bang bung , brunch ; bog bong', [',', ';']) returns Array('big bang bung', 'brunch', 'bog bong']
     */

    public static function explode_multiple($string, $delimiters)
    {
        $delims = array_map(function ($value) {
            return preg_quote($value);
        }, $delimiters);
        $delims = join('|', $delims);
        $output = preg_split("/($delims)/", $string);

        return array_map('trim', array_filter($output));

    }

    /**
     * @function flatten : flatten an array to a single dimensio array
     * @param array $array : recursive depth where to join (starts at 0)
     * @usage : flatten([ 'ba', [ 'bo' ], [ ['bi', 'bo', 'bu'] ] ]) returns ['ba', 'bo', 'bi', 'bo', 'bu']
     */
    public static function flatten($array)
    {
        $return = array();
        array_walk_recursive($array, function ($a) use (&$return) {
            $return[] = $a;
        });
        return $return;
    }

    /**
     * @function combine : combines two field to create a new array
     * @param $array
     * @param $id_field , can be '~key' -> then the key will be used
     * @param $value_field
     * @return array combined
     * @usage :
     *      Glb_Aray::combine(
     *              ['key1' => ['name' => 'key1_name', 'value' => 'key1_value'],
     *              'key2' => ['name' => 'key2_name', 'value' => 'key2_value']],
     *              'name', 'value'
     *      )
     *      will return :
     *              ['key1_name' => 'key1_value', 'key2_name' => 'key2_value']
     *
     *
     *      Glb_Aray::combine(
     *              ['key1' => ['name' => 'key1_name', 'value' => 'key1_value'],
     *              'key2' => ['name' => 'key2_name', 'value' => 'key2_value']],
     *              '~key', 'value'
     *      )
     *      will return :
     *              ['key1' => 'key1_value', 'key2' => 'key2_value']
     */
    public static function combine($array, $id_field, $value_field)
    {

        $result = [];
        foreach ($array as $itemKey => $item) {
            if ($id_field == '~key') {
                $result[$itemKey] = $item[$value_field];
            } else {
                $result[$item[$id_field]] = $item[$value_field];
            }
        }
        return $result;
    }

    /**
     * Remove value
     */
    public static function remove_value(&$array, $value) {
        self::ensure($value);
        foreach($value as $value_item) {
            while (($key = array_search($value_item, $array)) !== false) {
                unset($array[$key]);
            }
        }
        return $array;
    }

    public static function simplify($array, $keys = null, $length = PHP_INT_MAX) {
        $result = []; $i = 0;
        foreach($array as $key => $value) {
            $result[$key] = [];
            foreach($value as $value_key => $value_value) {
                if (empty($keys) || in_array($value_key, $keys)) {
                    $result[$key][$value_key] = $value_value;
                }
            }
            if (empty($result[$key])) {
                unset($result[$key]);
            }
            if ($i == $length - 1) {
                break;
            }
            $i++;
        }
        return $result;
    }

    public static function extract_keys($array, $keys) {

        if (empty($keys)) {
            return $array;
        }

        $result = [];
        $array_keys = array_keys($array);
        $keys = array_intersect($array_keys, $keys);

        foreach($keys as $key) {
            $result[$key] = $array[$key];
        }

        return $result;

    }

    /**
     * @param $array Array to search in
     * @param $pattern Regexp pattern to evaluate
     * @param string $on_what : keys | values | both
     * @return array
     */
    public static function extract($array, $pattern, $on_what = 'values') {

        $result = [];
        $extract_values = in_array($on_what, ['value', 'values', 'both', 'all']);
        $extract_keys = in_array($on_what, ['key', 'keys', 'both', 'all']);

        foreach($array as $key => $value) {
            if ($extract_keys && preg_match($pattern, $key)) {
                $result[$key] = $value;
            } else if ($extract_values && preg_match($pattern, $value)) {
                $result[$key] = $value;
            }
        }

        return $result;

    }

    /**
     * Dedupe data array, only for sequential keyed values
     * @usage :
     *         Glb_Array::dedupe( ['mum', 'dad', 'bro', 'key1' => 'mum', 'mum', 'key2' => 'dad', 'dad', 'key_bro' => 'bro'] );
     *              returns ['mum', 'dad', 'bro', 'key1' => 'mum', 'key2' => 'dad', 'key_bro' => 'bro']
     */
    public static function dedupe(&$array) {

        // loop main table
        //foreach($array as $key => $value) {
            //if (is_array($value)) {
                // extract int keys
                $sequential = self::extract($array, '/^\d+$/', 'keys');
                // count them
                try {
                    $counted_values = self::count_values($sequential);
                    if (empty($counted_values)) {
                        return $array;
                    }
                    foreach(array_count_values($sequential) as $current_value => $count) {
                        if ($count > 1) {
                            // find the concerned keys
                            $duplicate_keys = array_keys($array, $current_value, true);
                            // only keep the first
                            array_shift($duplicate_keys);
                            // remove the rest
                            foreach($duplicate_keys as $duplicate_key) {
                                unset($array[$duplicate_key]);
                            }
                        }
                    }
                } catch (Exception $ex) {
                    return $array;
                }
            //}
        //}

        return $array;

    }

    public static function count_values($array) {

        try {
            $result = @array_count_values($array);
        } catch (Exception $ex) {
            return false;
        }
        if (empty($result)) {
            return false;
        } else {
            return $result;
        }

    }

    public static function get_stack($stack = null, $options = ['func' => false, 'func_args' => false, 'line' => false]) {
        if ($stack === null) {
            $stack = debug_backtrace();
        }
        $output = [];

        for ($i = 1; $i < count($stack); $i++) {
            $entry = $stack[$i];
            if (empty($entry['file'])) {
                continue;
            }

            if (empty($options['func'])) {

                $output[] = $entry['file'] . (empty($options['line']) ? '' : ':' . $entry['line']);

            } else {

                $func = $entry['function'] . '(';

                if (!empty($options['func_args'])) {
                    $argsLen = count($entry['args']);
                    for ($j = 0; $j < $argsLen; $j++) {
                        if (is_scalar($entry['args'][$j])) {
                            $func .= $entry['args'][$j];
                        } else if (is_object($entry['args'][$j])) {
                            $func .= get_class($entry['args'][$j]);
                        } else if (is_array($entry['args'][$j])) {
                            $func .= str_replace("\n", " ", str_replace("\r", "", print_r($entry['args'][$j], true)));
                        }
                        if ($j < $argsLen - 1) $func .= ', ';
                    }
                }
                $func .= ')';
                $output[] = $entry['file'] . (empty($options['line']) ? '' : ':' . $entry['line']) . ' - ' . $func;
            }
        }
        return $output;
    }

    /**
     * @param $array
     * @param $needle
     * @param string $strict
     * @return bool
     */
    public static function find_value($array, $needle, $options = 'strict') {
        $strict = (strpos($options, 'strict') !== false);
        $insensitive = (strpos($options, 'icase') !== false || strpos($options, 'i_case') !== false || strpos($options, 'casei') !== false || strpos($options, 'case_i') !== false || strpos($options, 'insensitive') !== false);

        if ($insensitive) {
            return array_search(strtolower($needle), array_map('strtolower', $array), $strict);
        } else {
            return array_search($needle, $array, $strict);
        }
    }

}
