<?php

class Glb_Core_Archivable_Behavior extends Glb_Behavior {

    public function initialize($options) {
        $this->_options = array_merge([
            'archived' => 'archived',
            'archived_by' => 'archived_by',
            'hide_archived' => true,
            'avoid_deletion' => true,
            'date_format' => 'Y-m-d H:i:s'
        ], $options);
    }

    public function before_select($query, $event, $options) {
        // @todo : add contain for users
        if ($this->_check_field('archived', $event['table']) && !empty($this->_options['hide_archived'])) {
            $query->where([$event['table']->alias . '.' . $this->_options['archived'] . 'IS' => null]);
        }
    }

    public function before_delete($query, $event, $options) {
        if (!$this->_options['avoid_deletion']) {
            return;
        }
        if ($this->_check_field('archived', $event['table'])) {
            $event['entity']['archived'] = date($this->_options['date_format']);
        }
        if ($this->_check_field('archived_by', $event['table'])) {
            $event['entity']['archived_by'] = Glb_Users::current()->ID;
        }

        //$event['table']->save($event['entity']);
        $event->stop();

    }
}
