<div class="glb-unit-tests-results">

    <?php

    foreach ($results as $plugin_name => $plugin_result) {

        foreach ($plugin_result as $result_class => $result_value) {

            $result_types = array_keys($result_value);
            $class_add = $class_message = '';

            // only display the class name if all tests were OK
            if ($result_types === ['passed']) {
                $class_message = '' . __glb('%s %d test(s) passed', ['<span class="dashicons dashicons-yes-alt"></span>', count($result_value['passed'])]);
                $class_add = ' glb-success';
                unset($result_value['passed']);
            } else {
                $class_message = '<span class="dashicons dashicons-clipboard"></span>&nbsp;' . __glb('Are you serious, buddy ?');
                $class_add = ' glb-question';
                if (in_array('failures', $result_types) || in_array('errors', $result_types)) {
                    $class_add = ' glb-error';
                } else if (in_array('warnings', $result_types) || in_array('risky', $result_types)) {
                    $class_add = ' glb-warning';
                }
            }
            ?>

            <div class="glb-unit-tests-results glb-unit-tests-results-<?= Glb_Text::slug($result_class) ?>">
                <h3 class="glb-unit-tests-results-title glb-vcenter<?= $class_add ?>"><span class="plugin-name"><?= $plugin_name ?></span><span class="test-name"><?=$result_class?></span><span class="results"><?=$class_message?></span></h3>
                <?php
                foreach ($result_value as $result_type => $class_results) {
                    if (!empty($class_results)) {
                        ?>
                        <div class="glb-unit-tests-results-type glb-unit-tests-results-type-<?= Glb_Text::slug($result_type) ?>">
                            <?php
                            foreach ($class_results as $result_key => $result) {
                                $specifics = [
                                    'failures' => ['dismiss', 'error'],
                                    'errors' => ['dismiss', 'error'],
                                    'warnings' => ['warning', 'warning'],
                                    'passed' => ['yes-alt', 'success'],
                                    'skipped' => ['editor-help', 'question'],
                                    'risky' => ['editor-help', 'warning'],
                                ];
                                $specific = $specifics[$result_type];
                                echo '<div class="glb-' . $specific[1] . '">';
                                echo '<span class="dashicons dashicons-' . $specific[0] . '"></span>';
                                //glb_dump($result);

                                echo '<span class="glb-unit-tests-results-name"><strong>' . (!empty($result['name']) ? $result['name'] . ' : ' : '') . '</strong></span>';
                                echo '<span class="glb-unit-tests-results-description"><strong>' . $result['description'] . '</strong></span>';
                                Glb_Array::ensure($result['message']);
                                foreach($result['message'] as $item) {
                                    echo '<br><span class="glb-unit-tests-results-message">' . $item . '</span>';
                                }
                                if (!empty($result['details']['expected'])) {
                                    echo '<br><span class="glb-unit-tests-results-details">';
                                    echo 'Expected : ' . nl2br(str_replace(' ', '&nbsp;', $result['details']['expected']));
                                    echo '<br>Actual : ' . nl2br(str_replace(' ', '&nbsp;', nl2br($result['details']['actual'])));
                                    echo '</span>';
                                }

                                echo '</div>';

                            }
                            ?>
                        </div>
                        <?php
                    }
                }
                ?>
            </div>
            <?php
        }
    }
?>
</div>