<?php

/**
 * Provide a admin area view for the plugin
 *
 * This file is used to markup the admin-facing aspects of the plugin.
 *
 * @link       http://example.com
 * @since      1.0.0
 *
 * @package    Gloubi_Boulga
 * @subpackage Gloubi_Boulga/admin/partials
 */
?>

<div class="wrap">

    <h1><?= __glb('Gloubi-Boulga\'s gloubal admin page') ?></h1>

    <?php

    $current_tab = 'settings';
    if (!empty($_GET['tab'])) { $current_tab = $_GET['tab']; }
    ?>

    <h2 class="nav-tab-wrapper">
    <a href="admin.php?page=glb_admin_page&tab=settings" class="nav-tab<?= ($current_tab == 'settings' ? ' nav-tab-active' : '') ?>"><?= __glb('Settings') ?> </a>
    <a href="admin.php?page=glb_admin_page&tab=tools" class="nav-tab<?= ($current_tab == 'tools' ? ' nav-tab-active' : '') ?>"><?= __glb('Tools') ?> </a>
    <a href="admin.php?page=glb_admin_page&tab=logs" class="nav-tab<?= ($current_tab == 'logs' ? ' nav-tab-active' : '') ?>"><?= __glb('Logs') ?> </a>
    <a href="admin.php?page=glb_admin_page&tab=system" class="nav-tab<?= ($current_tab == 'system' ? ' nav-tab-active' : '') ?>"><?= __glb('System') ?> </a>
    <a href="admin.php?page=glb_admin_page&tab=generator" class="nav-tab<?= ($current_tab == 'generator' ? ' nav-tab-active' : '') ?>"><?= __glb('Generator') ?> </a>
    </h2>

    <?php
    // save glb_core settings
    if ($current_tab == 'logs') {

        Glb_Admin_Table_Column::set_table('core_logs');
        $columns = [
            new Glb_Admin_Table_Column('id', false, ['primary' => true]),
            new Glb_Admin_Table_Column('created', __glb('Date'), ['sort' => 'desc']),
            new Glb_Admin_Table_Column('plugin_name', __glb('Plugin'), ['sort' => 'asc', 'search']),
            new Glb_Admin_Table_Column('action', __glb('Action'), ['sort' => 'desc', 'search']),
            new Glb_Admin_Table_Column('message', __glb('Message'), ['sort' => 'desc', 'search' => ['message', 'message_args', 'message_details', 'message_details_args']]),
            new Glb_Admin_Table_Column('user_id', false),
            new Glb_Admin_Table_Column('user_description', __glb('User'), ['search', 'sort']),
        ];

        // select disinct actions for filters
        $actions = Glb_Table::get('core_logs')->query('select')->modifiers('distinct')
            ->fields('action')->order('core_logs.action')->execute()->extract('action');

        $users = Glb_Table::get('core_users')->query('select')->modifiers('distinct')
            ->order('user_login')->execute()
            ->combine('ID', function($item) {
                return Glb_Users::glb_display($item);
            });

        // build filters columns
        $filters = [
                'core_logs.user_id' => ['label' => 'All users', 'values' => $users, 'type' => '%d'] ,
                'core_logs.plugin_key' => ['label' => __glb('All plugins'),
                    'values' => Glb_Plugin::get_registered(), 'type' => '%s'],
                'core_logs.action' => ['label' => 'All actions', 'type' => '%s', 'attrs' => ['data-multiple' => true],
                    'values' => Glb_Array::convert_associative($actions)]
            ];

        class Glb_Core_Activity_Admin_Table extends Glb_Admin_Table {
            public function column_user_description($item) {
                $result = Glb_Users::glb_display($item->user_id);
                if (empty($result)) {
                    $result = "< " . $item->user_description . " >";
                }
                return $this->format_text('user_description', glb_esch($result));
            }
        };

        $table = new Glb_Core_Activity_Admin_Table ( $columns, $filters, $actions, ['order_by' => 'created', 'order_dir' => 'desc', 'table_class' => 'glb-admin-activity-table'] );

        // get applied filters and interpret them as WHERE
        $applied_filters = $table->get_applied(true);
        $paging = $table->get_paging();

        // load items
        $items = Glb_Table::get('core_logs')
            ->query('select')
            //->contain('core_users')
            ->order([$paging['order_by'] => $paging['order_dir']])
            ->limit($paging['per_page'])
            ->where($applied_filters);

        // calculate total item count & execute
        $total_items = $items->count();
        $paging['paged'] = ($total_items < $paging['paged']) ? 0 : $paging['paged'];
        $items->offset($paging['paged']);

        glb_dump($items->sql());
        $items = $items->execute();

        $table->set_items($items, $total_items);
        $table->prepare_items();

    }

    ?>


    <form method="post" action="" method="POST">

    <?php
    if ($current_tab == 'settings') {
        echo '<input type="hidden" name="glb_nonce" value="' . $this->request->create_nonce('glb-core-admin-settings-submit') . '">';
        $this->render_template('core:elements/glb-core-admin-settings-table');
        submit_button(__glb('Save changes'), 'primary', 'glb_core_settings_submit');
    } else if ($current_tab == 'logs') {

        $table->views();
        $table->display();

    } else if ($current_tab == 'system') {
        ?>
        <table class="form-table">
            <tbody>
                <?php
                    foreach($params['sys_props'] as $prop_key => $prop) {
                        ?>
                        <tr>
                            <th scope="row glb-system-prop glb-system-prop-<?=$prop_key?>"><?= $prop['label'] ?></th>
                            <td scope="row glb-system-prop glb-system-prop-<?=$prop_key?>"><?= $prop['value'] ?></td>
                        </tr>
                <?php
                    }
            ?>
            </tbody>
        </table>
        <?php
    } else if ($current_tab == 'tools') {
        ?>
        <input type="hidden" name="glb_nonce" value="<?=$this->request->create_nonce('glb-core-admin-tools-submit')?>">
        <table class="form-table">
            <tbody>
            <tr>
                <?php
                $setting = [
                    'name' => 'glb_core_tools_silence_is_golden',
                    'description' => __glb('Will look into all Gloubi plugins folders to check if secured « silence is golden » index.php exists. If not, it will create it.'),
                    'label' => __glb('« Silence is golden »'),
                    'value' => 'glb_core_tools_silence_is_golden'
                ];
                echo '<th scope="row">' . Glb_Html::get('label')->html($setting) . '</th><td>';
                echo Glb_Html::get('checkbox')->html($setting, ['title' => __glb('Check « silence is golden » files')]);
                $setting['label'] = __glb('Will look into all Gloubi plugins folders to check if secured « silence is golden » index.php exists. If not, it will create it.');
                echo '&nbsp;' . Glb_Html::get('label')->html($setting) . '</td>';
                ?>
            </tr>
            <?php
                if (!empty($params['unit_tests'])) {
                    echo '<tr><td colspan="100%">';
                    $this->render_template('elements/glb-core-unit-tests-results', ['results' => $params['unit_tests']]);
                echo '</td></tr>';
                }
            ?>
            <tr>
                <?php
                $setting = [
                    'name' => 'glb_core_tools_unit_tests',
                    'description' => __glb('Will run all unit tests for all Gloubi plugins'),
                    'label' => __glb('Unit tests'),
                    'value' => 'glb_core_tools_unit_tests'
                ];
                echo '<th scope="row">' . Glb_Html::get('label')->html($setting) . '</th><td>';
                echo Glb_Html::get('checkbox')->html($setting, ['title' => __glb('Unit tests')]);
                echo '&nbsp;' . Glb_Html::get('description')->html($setting) . '</td>';
                ?>
            </tr>
            </tbody>
        </table>

        <!--tr>
            <th scope="row">Membership</th>
            <td> <fieldset><legend class="screen-reader-text"><span>Membership</span></legend><label for="users_can_register">
                        <input name="users_can_register" type="checkbox" id="users_can_register" value="1">
                        Anyone can register</label>
                </fieldset></td>
        </tr-->

        <?php
        submit_button(__glb('Go now !'), 'primary', 'glb_core_admin_tools_submit');

    } else if ($current_tab == 'generator') {

        $params = [
                    ['name' => 'name',
                        'data_type' => 'text', 'required' => true, 'default' => __glb('Dust Hunters'),
                        'label' => __glb('Plugin name'), 'description' => __glb('Your plugin name should be as short as possible (example : File manager). Don\'t use "Plugin" or "Gloubi" or "Boulga" words in that.')],
                    ['name' => 'short_name', 'default' => __glb('Dusters'),
                        'data_type' => 'text', 'required' => true,
                        'label' => __glb('Short name'), 'description' => __glb('A short name that will be used for naming variables and classes (example : Fmanager). Don\'t use "Plugin" or "Gloubi" or "Boulga" words in that.')],
                    ['name' => 'version',
                        'data_type' => 'text', 'required' => true,
                        'label' => __glb('Version'), 'default' => '0.0.1'],
                    ['name' => 'description',
                        'data_type' => 'longtext', 'required' => true, 'default' => __glb('Track down dust everywhere to help dust phobics'),
                        'label' => __glb('Description'),
                        'description' => __glb('The full description of what your plugin is expected to do (for admin area).')],
                    ['name' => 'link',
                        'data_type' => 'url', 'label' => __glb('Plugin Url'),
                        'description' => __glb('A URL for your plugin ?')],
                    ['name' => 'database', 'value' => 'true',
                        'data_type' => 'boolean', 'label' => __glb('Database example installation'),
                        'description' => __glb('Checking this will install a database table and it\'s manager interface.')],
                    ['name' => 'main_use',
                        'data_type' => 'text', 'label' => __glb('Main use'), 'default' => 'dust',
                        'description' => __glb('What is the main use of your plugin, in one word and in singular form (for example "file" if your plugin will manage files) ? This will be used to create an example sql table.')],
                    ['name' => 'roles', 'value' => 'true',
                        'data_type' => 'boolean', 'label' => __glb('Create user roles/capabilities'),
                        'description' => __glb('Checking this will create user\'s roles / capabilities.')],
                    ['name' => 'author',
                        'data_type' => 'text', 'label' => __glb('Author name'), 'default' => 'John Smith'],
                    ['name' => 'author_url',
                        'data_type' => 'url', 'label' => __glb('Author URL')],
                    ['name' => 'license',
                        'data_type' => 'text', 'label' => __glb('License'), 'default' => 'MIT',
                        'description' => __glb('Examples : GPLv2, GPLv3, MIT, BSD...')],
                    ['name' => 'license_url',
                        'data_type' => 'url', 'label' => __glb('License URL'),
                        'description' => __glb('A URL for the previous license.')],
                    ['name' => 'priority',
                        'data_type' => 'integer', 'label' => __glb('Priority'), 'default' => 5,
                        'description' => __glb('The plugin priority.')],
            ];

        echo '<p><strong><i class="dashicons dashicons-warning glb-warning"></i>&nbsp;' . __glb('Please don\'t use that if you are not fully aware of what you are doing !') . '</strong></p>';
        echo '<input type="hidden" name="glb_nonce" value="' . $this->request->create_nonce('glb-core-generator-process') . '">';
        echo '<table class="form-table generator-settings-table">';
        echo '<tbody>';
        foreach($params as $param) {
            $param = new Glb_Plugin_Setting($param['name'], $param['data_type'], Glb_Hash::get($param, 'label'), $param);
            echo '<tr class="generator-' . Glb_Text::slug($param->name) . '"><th scope="row" class="' . Glb_Text::slug($param->name) . '">' . $param->html('label') . '</th><td>' . $param->html('input') . (empty($param['description']) ? '' : $param->html('description')) . '</td></tr>';
        }
        echo '</tbody>';
        echo '</table>';

        submit_button(__glb('Go now !'), 'primary', 'glb_core_generator_submit');

    }
    ?>

    </form>

</div>