<?php

use PHPUnit\Framework\TestCase;

class Glb_Array_Tests extends Glb_Test_Case {


    public function testConvertAssociative() {

        $tests = [
            [ 'convert_associative()', ['Glb_Array', 'convert_associative'], [['mum', 'dad', 'postman'], null], ['mum' => 'mum', 'dad' => 'dad', 'postman' => 'postman'] ],
            [ 'convert_associative()', ['Glb_Array', 'convert_associative'], [['mum', 'dad', 'postman'], []], ['mum' => [], 'dad' => [], 'postman' => []] ],
            [ 'convert_associative()', ['Glb_Array', 'convert_associative'], [['mum', 'dad', 'postman' => ['weird', 'thing']], null], ['mum' => 'mum', 'dad' => 'dad', 'postman' => ['weird', 'thing']] ],
            [ 'convert_associative()', ['Glb_Array', 'convert_associative'], [['mum', 'dad', 'postman' => ['weird', 'thing']], []], ['mum' => [], 'dad' => [], 'postman' => ['weird', 'thing']] ],
        ];
        $this->_testBulkEquals($tests);

    }

    public function testExplodeNudge() {

        $tests = [
            [ 'explode_nudge()', ['Glb_Array', 'explode_nudge'], ['my_table.my_field', '.', 2], ['my_table', 'my_field'] ],
            [ 'explode_nudge()', ['Glb_Array', 'explode_nudge'], ['my_field', '.', 2], [null, 'my_field'] ],
            [ 'explode_nudge()', ['Glb_Array', 'explode_nudge'], ['my_field', '.', 3, 'x'], ['x', 'x', 'my_field'] ],
            [ 'explode_nudge()', ['Glb_Array', 'explode_nudge'], ['key1.key2.key3', '.', 2, 'x'], ['key1', 'key2.key3'] ],
        ];
        $this->_testBulkEquals($tests);

    }
}
