<?php

use PHPUnit\Framework\TestCase;

class Glb_Hash_Tests extends Glb_Test_Case {


    public function testFirst() {

        $tests = [
            [ 'first()', ['Glb_Hash', 'first'], [['mum' => '0', 'dad' => 1, 'postman' => 2], ['evelyne', 'john', 'postman'], 'value', null], 2 ],
            [ 'first()', ['Glb_Hash', 'first'], [new ArrayObject(['mum' => '0', 'dad' => 1, 'postman' => 2]), ['evelyne', 'john', 'postman'], 'value', null], 2 ],
            [ 'first()', ['Glb_Hash', 'first'], [(object)['mum' => '0', 'dad' => 1, 'postman' => 2], ['evelyne', 'john', 'postman'], 'value', null], 2 ],
            [ 'first()', ['Glb_Hash', 'first'], [new Glb_Entity(['mum' => '0', 'dad' => 1, 'postman' => 2]), ['evelyne', 'john', 'postman'], 'value', null], 2 ],

            [ 'first()', ['Glb_Hash', 'first'], [['mum' => '0', 'dad' => 1, 'postman' => 2], ['evelyne', 'john', 'postman'], 'key'], 'postman', null ],
            [ 'first()', ['Glb_Hash', 'first'], [new ArrayObject(['mum' => '0', 'dad' => 1, 'postman' => 2]), ['evelyne', 'john', 'postman'], 'key', null], 'postman' ],
            [ 'first()', ['Glb_Hash', 'first'], [(object)['mum' => '0', 'dad' => 1, 'postman' => 2], ['evelyne', 'john', 'postman'], 'key', null], 'postman' ],
            [ 'first()', ['Glb_Hash', 'first'], [new Glb_Entity(['mum' => '0', 'dad' => 1, 'postman' => 2]), ['evelyne', 'john', 'postman'], 'key', null], 'postman' ],

            [ 'first()', ['Glb_Hash', 'first'], [['mum' => '0', 'dad' => 1, 'postman' => 2], ['evelyne', 'john', 'postman'], 'both', null], ['key' => 'postman', 'value' => 2] ],
            [ 'first()', ['Glb_Hash', 'first'], [new ArrayObject(['mum' => '0', 'dad' => 1, 'postman' => 2]), ['evelyne', 'john', 'postman'], 'both', null], ['key' => 'postman', 'value' => 2] ],
            [ 'first()', ['Glb_Hash', 'first'], [(object)['mum' => '0', 'dad' => 1, 'postman' => 2], ['evelyne', 'john', 'postman'], 'both', null], ['key' => 'postman', 'value' => 2] ],
            [ 'first()', ['Glb_Hash', 'first'], [new Glb_Entity(['mum' => '0', 'dad' => 1, 'postman' => 2]), ['evelyne', 'john', 'postman'], 'both', null], ['key' => 'postman', 'value' => 2] ],
        ];
        $this->_testBulkEquals($tests);

    }

    public function testExists() {

        $tests = [
            [ 'exists()', ['Glb_Hash', 'exists'], [['mum' => '0', 'dad' => 1, 'postman' => 2], 'evelyne'], false ],
            [ 'exists()', ['Glb_Hash', 'exists'], [new ArrayObject(['mum' => '0', 'dad' => 1, 'postman' => 2]), 'evelyne'], false ],
            [ 'exists()', ['Glb_Hash', 'exists'], [(object)['mum' => '0', 'dad' => 1, 'postman' => 2], 'evelyne'], false ],
            [ 'exists()', ['Glb_Hash', 'exists'], [new Glb_Entity(['mum' => '0', 'dad' => 1, 'postman' => 2]), 'evelyne'], false ],

            [ 'exists()', ['Glb_Hash', 'exists'], [['mum' => '0', 'dad' => 1, 'postman' => 2], 'dad'], true ],
            [ 'exists()', ['Glb_Hash', 'exists'], [new ArrayObject(['mum' => '0', 'dad' => 1, 'postman' => 2]), 'dad'], true ],
            [ 'exists()', ['Glb_Hash', 'exists'], [(object)['mum' => '0', 'dad' => 1, 'postman' => 2], 'dad'], true ],
            [ 'exists()', ['Glb_Hash', 'exists'], [new Glb_Entity(['mum' => '0', 'dad' => 1, 'postman' => 2]), 'dad'], true ],

            [ 'exists()', ['Glb_Hash', 'exists'], [['mum' => '0', 'dad' => 1, 'postman' => ['child1' => 0, 'child2' => 1]], 'postman.child1'], true ],
            [ 'exists()', ['Glb_Hash', 'exists'], [new ArrayObject(['mum' => '0', 'dad' => 1, 'postman' => ['child1' => 0, 'child2' => 1]]), 'postman.child1'], true ],
            [ 'exists()', ['Glb_Hash', 'exists'], [(object)['mum' => '0', 'dad' => 1, 'postman' => ['child1' => 0, 'child2' => 1]], 'postman.child1'], true ],
            [ 'exists()', ['Glb_Hash', 'exists'], [new Glb_Entity(['mum' => '0', 'dad' => 1, 'postman' => ['child1' => 0, 'child2' => 1]]), 'postman.child1'], true ],

            [ 'exists()', ['Glb_Hash', 'exists'], [['mum' => '0', 'dad' => 1, 'postman' => ['child1' => 0, 'child2' => 1]], 'postman.child3'], false ],
            [ 'exists()', ['Glb_Hash', 'exists'], [new ArrayObject(['mum' => '0', 'dad' => 1, 'postman' => ['child1' => 0, 'child2' => 1]]), 'postman.child3'], false ],
            [ 'exists()', ['Glb_Hash', 'exists'], [(object)['mum' => '0', 'dad' => 1, 'postman' => ['child1' => 0, 'child2' => 1]], 'postman.child3'], false ],
            [ 'exists()', ['Glb_Hash', 'exists'], [new Glb_Entity(['mum' => '0', 'dad' => 1, 'postman' => ['child1' => 0, 'child2' => 1]]), 'postman.child3'], false ],
        ];
        $this->_testBulkEquals($tests);
    }

    public function testIsEmpty() {

        $tests = [
            [ 'is_empty()', ['Glb_Hash', 'is_empty'], [['mum' => '0', 'dad' => 1, 'postman' => 2], 'dad'], false ],
            [ 'is_empty()', ['Glb_Hash', 'is_empty'], [new ArrayObject(['mum' => '0', 'dad' => 1, 'postman' => 2]), 'dad'], false ],
            [ 'is_empty()', ['Glb_Hash', 'is_empty'], [(object)['mum' => '0', 'dad' => 1, 'postman' => 2], 'dad'], false ],
            [ 'is_empty()', ['Glb_Hash', 'is_empty'], [new Glb_Entity(['mum' => '0', 'dad' => 1, 'postman' => 2]), 'dad'], false ],

            [ 'is_empty()', ['Glb_Hash', 'is_empty'], [['mum' => '0', 'dad' => 1, 'postman' => 2], 'mum'], true ],
            [ 'is_empty()', ['Glb_Hash', 'is_empty'], [new ArrayObject(['mum' => '0', 'dad' => 1, 'postman' => 2]), 'mum'], true ],
            [ 'is_empty()', ['Glb_Hash', 'is_empty'], [(object)['mum' => '0', 'dad' => 1, 'postman' => 2], 'mum'], true ],
            [ 'is_empty()', ['Glb_Hash', 'is_empty'], [new Glb_Entity(['mum' => '0', 'dad' => 1, 'postman' => 2]), 'mum'], true ],

            [ 'is_empty()', ['Glb_Hash', 'is_empty'], [['mum' => '0', 'dad' => 1, 'postman' => ['child1' => 0, 'child2' => 1]], 'postman.child2'], false ],
            [ 'is_empty()', ['Glb_Hash', 'is_empty'], [new ArrayObject(['mum' => '0', 'dad' => 1, 'postman' => ['child1' => 0, 'child2' => 1]]), 'postman.child2'], false ],
            [ 'is_empty()', ['Glb_Hash', 'is_empty'], [(object)['mum' => '0', 'dad' => 1, 'postman' => ['child1' => 0, 'child2' => 1]], 'postman.child2'], false ],
            [ 'is_empty()', ['Glb_Hash', 'is_empty'], [new Glb_Entity(['mum' => '0', 'dad' => 1, 'postman' => ['child1' => 0, 'child2' => 1]]), 'postman.child2'], false ],

            [ 'is_empty()', ['Glb_Hash', 'is_empty'], [['mum' => '0', 'dad' => 1, 'postman' => ['child1' => 0, 'child2' => 1]], 'postman.child1'], true ],
            [ 'is_empty()', ['Glb_Hash', 'is_empty'], [new ArrayObject(['mum' => '0', 'dad' => 1, 'postman' => ['child1' => 0, 'child2' => 1]]), 'postman.child1'], true ],
            [ 'is_empty()', ['Glb_Hash', 'is_empty'], [(object)['mum' => '0', 'dad' => 1, 'postman' => ['child1' => 0, 'child2' => 1]], 'postman.child1'], true ],
            [ 'is_empty()', ['Glb_Hash', 'is_empty'], [new Glb_Entity(['mum' => '0', 'dad' => 1, 'postman' => ['child1' => 0, 'child2' => 1]]), 'postman.child1'], true ],
        ];
        $this->_testBulkEquals($tests);

    }

    public function testOneEmpty() {

        $tests = [
            [ 'one_empty()', ['Glb_Hash', 'one_empty'], [['mum' => '0', 'dad' => 1, 'postman' => 2], ['dad', 'postman']], false ],
            [ 'one_empty()', ['Glb_Hash', 'one_empty'], [new ArrayObject(['mum' => '0', 'dad' => 1, 'postman' => 2]), ['dad', 'postman']], false ],
            [ 'one_empty()', ['Glb_Hash', 'one_empty'], [(object)['mum' => '0', 'dad' => 1, 'postman' => 2], ['dad', 'postman']], false ],
            [ 'one_empty()', ['Glb_Hash', 'one_empty'], [new Glb_Entity(['mum' => '0', 'dad' => 1, 'postman' => 2]), ['dad', 'postman']], false ],

            [ 'one_empty()', ['Glb_Hash', 'one_empty'], [['mum' => '0', 'dad' => 1, 'postman' => 2], ['dad', 'postman', 'mum']], true ],
            [ 'one_empty()', ['Glb_Hash', 'one_empty'], [new ArrayObject(['mum' => '0', 'dad' => 1, 'postman' => 2]), ['dad', 'postman', 'mum']], true ],
            [ 'one_empty()', ['Glb_Hash', 'one_empty'], [(object)['mum' => '0', 'dad' => 1, 'postman' => 2], ['dad', 'postman', 'mum']], true ],
            [ 'one_empty()', ['Glb_Hash', 'one_empty'], [new Glb_Entity(['mum' => '0', 'dad' => 1, 'postman' => 2]), ['dad', 'postman', 'mum']], true ],

            [ 'one_empty()', ['Glb_Hash', 'one_empty'], [['mum' => '0', 'dad' => 1, 'postman' => ['child1' => 0, 'child2' => 1]], ['dad', 'postman.child2']], false ],
            [ 'one_empty()', ['Glb_Hash', 'one_empty'], [['mum' => '0', 'dad' => 1, 'postman' => ['child1' => 0, 'child2' => 1]], ['dad', 'postman.child1']], true ],
            [ 'one_empty()', ['Glb_Hash', 'one_empty'], [new ArrayObject(['mum' => '0', 'dad' => 1, 'postman' => ['child1' => 0, 'child2' => 1]]), ['dad', 'postman.child2']], false ],
            [ 'one_empty()', ['Glb_Hash', 'one_empty'], [new ArrayObject(['mum' => '0', 'dad' => 1, 'postman' => ['child1' => 0, 'child2' => 1]]), ['dad', 'postman.child1']], true ],

            [ 'one_empty()', ['Glb_Hash', 'one_empty'], [(object)['mum' => '0', 'dad' => 1, 'postman' => ['child1' => 0, 'child2' => 1]], ['dad', 'postman.child2']], false ],
            [ 'one_empty()', ['Glb_Hash', 'one_empty'], [(object)['mum' => '0', 'dad' => 1, 'postman' => ['child1' => 0, 'child2' => 1]], ['dad', 'postman.child1']], true ],
            [ 'one_empty()', ['Glb_Hash', 'one_empty'], [new Glb_Entity(['mum' => '0', 'dad' => 1, 'postman' => ['child1' => 0, 'child2' => 1]]), ['dad', 'postman.child2']], false ],
            [ 'one_empty()', ['Glb_Hash', 'one_empty'], [new Glb_Entity(['mum' => '0', 'dad' => 1, 'postman' => ['child1' => 0, 'child2' => 1]]), ['dad', 'postman.child1']], true ],

        ];
        $this->_testBulkEquals($tests);

    }

    public function testGet() {

        $tests = [
            [ 'get()', ['Glb_Hash', 'get'], [['mum' => '0', 'dad' => 1, 'postman' => ['child1', 'child2']], 'postman'], ['child1', 'child2'] ],
            [ 'get()', ['Glb_Hash', 'get'], [new ArrayObject(['mum' => '0', 'dad' => 1, 'postman' => ['child1', 'child2']]), 'postman'], ['child1', 'child2'] ],
            [ 'get()', ['Glb_Hash', 'get'], [(object)['mum' => '0', 'dad' => 1, 'postman' => ['child1', 'child2']], 'postman'], ['child1', 'child2'] ],
            [ 'get()', ['Glb_Hash', 'get'], [new Glb_Entity(['mum' => '0', 'dad' => 1, 'postman' => ['child1', 'child2']]), 'postman'], ['child1', 'child2'] ],

            [ 'get()', ['Glb_Hash', 'get'], [['mum' => '0', 'dad' => 1, 'postman' => ['child1', 'child2']], 'dad'], 1 ],
            [ 'get()', ['Glb_Hash', 'get'], [new ArrayObject(['mum' => '0', 'dad' => 1, 'postman' => ['child1', 'child2']]), 'dad'], 1 ],
            [ 'get()', ['Glb_Hash', 'get'], [(object)['mum' => '0', 'dad' => 1, 'postman' => ['child1', 'child2']], 'dad'], 1 ],
            [ 'get()', ['Glb_Hash', 'get'], [new Glb_Entity(['mum' => '0', 'dad' => 1, 'postman' => ['child1', 'child2']]), 'dad'], 1 ],

            [ 'get()', ['Glb_Hash', 'get'], [['mum' => '0', 'dad' => 1, 'postman' => ['child1', 'child2']], 'postman.1'], 'child2' ],
            [ 'get()', ['Glb_Hash', 'get'], [new ArrayObject(['mum' => '0', 'dad' => 1, 'postman' => ['child1', 'child2']]), 'postman.1'], 'child2' ],
            [ 'get()', ['Glb_Hash', 'get'], [(object)['mum' => '0', 'dad' => 1, 'postman' => ['child1', 'child2']], 'postman.1'], 'child2' ],
            [ 'get()', ['Glb_Hash', 'get'], [new Glb_Entity(['mum' => '0', 'dad' => 1, 'postman' => ['child1', 'child2']]), 'postman.1'], 'child2' ],

            [ 'get()', ['Glb_Hash', 'get'], [['mum' => '0', 'dad' => 1, 'postman' => ['child1' => 1, 'child2' => 2]], 'postman.child1'], 1 ],
            [ 'get()', ['Glb_Hash', 'get'], [new ArrayObject(['mum' => '0', 'dad' => 1, 'postman' => ['child1' => 1, 'child2' => 2]]), 'postman.child1'], 1 ],
            [ 'get()', ['Glb_Hash', 'get'], [(object)['mum' => '0', 'dad' => 1, 'postman' => ['child1' => 1, 'child2' => 2]], 'postman.child1'], 1 ],
            [ 'get()', ['Glb_Hash', 'get'], [new Glb_Entity(['mum' => '0', 'dad' => 1, 'postman' => ['child1' => 1, 'child2' => 2]]), 'postman.child1'], 1 ],
        ];
        $this->_testBulkEquals($tests);

    }


    public function testFindPattern() {

        $tests = [
            [ 'get()', ['Glb_Hash', 'find_value_pattern'], [['key1' => 'Devil', 'key2' => 'Satan', 'key3' => '666'], '/^\d+$/', 1, ['key0', 'key1', 'key2', 'key3']], ['666'] ],
            [ 'get()', ['Glb_Hash', 'find_value_pattern'], [['key1' => 'Devil', 'key2' => 'Satan', 'key3' => '666.0'], '/^\d+$/', 1, null], null ],
            [ 'get()', ['Glb_Hash', 'find_value_pattern'], [['key1' => 'Devil', 'key2' => 'Satan', 'key3' => '666'], '/^S.*$/', 1, ['key0', 'key1', 'key2', 'key3']], ['Satan'] ],
            [ 'get()', ['Glb_Hash', 'find_value_pattern'], [['key1' => 'Devil', 'key2' => 'Satan', 'key3' => '666'], '/^S.*$/', 1, ['key0', 'key1', 'key2', 'key3'], 'key'], ['key2'] ],
            [ 'get()', ['Glb_Hash', 'find_value_pattern'], [['key1' => 'Devil', 'key2' => 'Satan', 'key3' => '666'], '/^S.*$/', 1, ['key0', 'key1', 'key2', 'key3'], 'both'], [['key' => 'key2', 'value' => 'Satan']] ],
        ];
        $this->_testBulkEquals($tests);

    }

    public function testSetRemove() {

        $processed = $original = ['key1' => '1', 'key2' => '2', 'key3' => ['subkey1' => 1, 'subkey2' => 2]];
        $added = ['carpe' => 'diem', 'take' => 'good time', 'and enjoy life !'];
        $expected = ['key1' => '1', 'key2' => '2', 'key3' => ['subkey1' => 1, 'subkey2' => 2], 'key4' => $added];

        // test array
        $result = Glb_Hash::set($processed, 'key4', $added);
        $this->assertEquals($added, $result, '#1 set()');
        $this->assertEquals($expected, $processed, '#1 set(result)');
        $removed = Glb_Hash::remove($processed, 'key4');
        $this->assertEquals($removed, $added, '#1 remove()');
        $this->assertEquals($original, $processed, '#1 final test');

        // test ArrayObject
        $processed2 = new ArrayObject($original);
        $added2 = new ArrayObject($added);
        $expected2 = new ArrayObject($expected); $expected2['key4'] = new ArrayObject($expected2['key4']);
        $original2 = new ArrayObject($original);

        $result = Glb_Hash::set($processed2, 'key4', $added2);
        $this->assertEquals($added2, $result, '#2 set()');
        $this->assertEquals($expected2, $processed2, '#2 set(result)');
        $removed = Glb_Hash::remove($processed2, 'key4');
        $this->assertEquals($removed, $added2, '#2 remove()');
        $this->assertEquals($original2, $processed2, '#2 final test');

        // test object
        $processed2 = (object)($original);
        $added2 = (object)($added);
        $expected2 = (object)($expected); $expected2->key4 = (object)($expected2->key4);
        $original2 = (object)($original);

        $result = Glb_Hash::set($processed2, 'key4', $added2);
        $this->assertEquals($added2, $result, '#3 set()');
        $this->assertEquals($expected2, $processed2, '#3 set(result)');
        $removed = Glb_Hash::remove($processed2, 'key4');
        $this->assertEquals($removed, $added2, '#3 remove()');
        $this->assertEquals($original2, $processed2, '#3 final test');

        // test Glb_Entity
        $processed2 = new Glb_Entity($original);
        $added2 = new Glb_Entity($added);
        $expected2 = new Glb_Entity($expected); $expected2->key4 = new Glb_Entity($expected2->key4);
        $original2 = new Glb_Entity($original);

        $result = Glb_Hash::set($processed2, 'key4', $added2);
        $this->assertEquals($added2, $result, '#4 set()');
        $this->assertEquals($expected2->to_array(), $processed2->to_array(), '#4 set(result)');
        $removed = Glb_Hash::remove($processed2, 'key4');
        $this->assertEquals($removed, $added2, '#4 remove()');
        $this->assertEquals($original2->to_array(), $processed2->to_array(), '#4 final test');

        // test key as path
        $processed = $original = ['key1' => '1', 'key2' => '2', 'key3' => ['subkey1' => 1, 'subkey2' => 2]];
        $added = ['carpe' => 'diem', 'take' => 'good time', 'and enjoy life !'];
        $expected = ['key1' => '1', 'key2' => '2', 'key3' => ['subkey1' => 1, 'subkey2' => 2], 'key4' => ['deeper' => ['deeper' => ['deeper' => ['okgood' => $added]]]]];

        // test array
        $result = Glb_Hash::set($processed, 'key4.deeper.deeper.deeper.okgood', $added);
        $this->assertEquals($added, $result, '#5 set()');
        $this->assertEquals($expected, $processed, '#5 set(result)');
        $removed = Glb_Hash::remove($processed, 'key4');
        $this->assertEquals($removed, ['deeper' => ['deeper' => ['deeper' => ['okgood' => $added]]]], '#5 remove()');
        $this->assertEquals($original, $processed, '#5 final test');

        // test ArrayObject
        $original2 = new ArrayObject($original);
        $processed2 = new ArrayObject($original);
        $added2 = $added;
        $expected2 = new ArrayObject($expected);
        /*$expected2['key4'] = new ArrayObject($expected2['key4']);
        $expected2['key4']['deeper'] = new ArrayObject($expected2['key4']['deeper']);
        $expected2['key4']['deeper']['deeper'] = new ArrayObject($expected2['key4']['deeper']['deeper']);
        $expected2['key4']['deeper']['deeper']['deeper'] = new ArrayObject($expected2['key4']['deeper']['deeper']['deeper']);
        $expected2['key4']['deeper']['deeper']['deeper']['okgood'] = new ArrayObject($expected2['key4']['deeper']['deeper']['deeper']['okgood']);*/

        $result = Glb_Hash::set($processed2, 'key4.deeper.deeper.deeper.okgood', $added2);
        $this->assertEquals($added2, $result, '#6 set()');
        $this->assertEquals($expected2, $processed2, '#6 set(result)');
        $removed = Glb_Hash::remove($processed2, 'key4');
        $this->assertEquals($removed, $expected2['key4'], '#6 remove()');
        $this->assertEquals($original2, $processed2, '#6 final test');

        // test object
        $original2 = (object)($original);
        $processed2 = (object)($original);
        $added2 = $added;
        $expected2 = (object)($expected);
        /*$expected2->key4 = (object)($expected2->key4);
        $expected2->key4->deeper = (object)($expected2->key4->deeper);
        $expected2->key4->deeper->deeper = (object)($expected2->key4->deeper->deeper);
        $expected2->key4->deeper->deeper->deeper = (object)($expected2->key4->deeper->deeper->deeper);
        $expected2->key4->deeper->deeper->deeper->okgood = (object)($expected2->key4->deeper->deeper->deeper->okgood);*/

        $result = Glb_Hash::set($processed2, 'key4.deeper.deeper.deeper.okgood', $added2);
        $this->assertEquals($added2, $result, '#7 set()');
        $this->assertEquals($expected2, $processed2, '#7 set(result)');
        $removed = Glb_Hash::remove($processed2, 'key4');
        $this->assertEquals($removed, $expected2->key4, '#7 remove()');
        $this->assertEquals($original2, $processed2, '#7 final test');

        // test Glb_Entity
        $original2 = new Glb_Entity($original);
        $processed2 = new Glb_Entity($original);
        $added2 = $added;
        $expected2 = new Glb_Entity($expected);
        /*$expected2['key4'] = new Glb_Entity($expected2['key4']);
        $expected2['key4']['deeper'] = new Glb_Entity($expected2['key4']['deeper']);
        $expected2['key4']['deeper']['deeper'] = new Glb_Entity($expected2['key4']['deeper']['deeper']);
        $expected2['key4']['deeper']['deeper']['deeper'] = new Glb_Entity($expected2['key4']['deeper']['deeper']['deeper']);
        $expected2['key4']['deeper']['deeper']['deeper']['okgood'] = new Glb_Entity($expected2['key4']['deeper']['deeper']['deeper']['okgood']);*/

        $result = Glb_Hash::set($processed2, 'key4.deeper.deeper.deeper.okgood', $added2);
        $this->assertEquals($added2, $result, '#8 set()');
        $this->assertEquals($expected2->to_array(), $processed2->to_array(), '#8 set(result)');
        $removed = Glb_Hash::remove($processed2, 'key4');
        $this->assertEquals($removed, $expected2['key4'], '#8 remove()');
        $this->assertEquals($original2->to_array(), $processed2->to_array(), '#8 final test');

    }

    public function testAppendRemove() {

        $processed = [];

        // test array
        $result = Glb_Hash::append($processed, 'mum', '32 teeth');
        $this->assertEquals($result, '32 teeth', '#1 append(result)');
        $this->assertEquals($processed, ['mum' => '32 teeth'], '#1 apend()');

        $result = Glb_Hash::append($processed, 'mum', 'all white');
        $this->assertEquals($result, ['32 teeth', 'all white'], '#2 append(result)');
        $this->assertEquals($processed, ['mum' => ['32 teeth', 'all white']], '#2 append()');

        $processed = [];
        $result = Glb_Hash::append($processed, 'dad.is.rugbyman', 'allblack');
        $this->assertEquals($result, 'allblack', '#3 append(result)');
        $this->assertEquals($processed, ['dad' => ['is' => ['rugbyman' => 'allblack']]], '#3 append()');

        $result = Glb_Hash::append($processed, 'dad.is', 'aman');
        $this->assertEquals($result, ['aman', 'rugbyman' => 'allblack'], '#4 append(result)');
        $this->assertEquals($processed, ['dad' => ['is' => ['aman', 'rugbyman' => 'allblack']]], '#4 append()');

        $result = Glb_Hash::remove($processed, 'dad.is.aman');
        $this->assertEquals($result, null, '#5 append(result)');
        $this->assertEquals($processed, ['dad' => ['is' => ['aman', 'rugbyman' => 'allblack']]], '#5 append()');

        $result = Glb_Hash::remove($processed, 'dad.is.rugbyman');
        $this->assertEquals($result, 'allblack', '#6 append(result)');
        $this->assertEquals($processed, ['dad' => ['is' => ['aman']]], '#6 append()');

        $result = Glb_Hash::remove($processed, 'dad');
        $this->assertEquals($result, ['is' => ['aman']], '#7 append(result)');
        $this->assertEquals($processed, [], '#7 append()');

        // test ArrayObject
        $processed = new ArrayObject([]);
        $result = Glb_Hash::append($processed, 'mum', '32 teeth');
        $this->assertEquals($result, '32 teeth', '#1 append(ao, result)');
        $this->assertEquals($processed, new ArrayObject(['mum' => '32 teeth']), '#1 append(ao)');

        $result = Glb_Hash::append($processed, 'mum', 'all white');
        $this->assertEquals($result, ['32 teeth', 'all white'], '#2 append(ao, result)');
        $this->assertEquals($processed, new ArrayObject(['mum' => ['32 teeth', 'all white']]), '#2 append(ao)');

        $processed = new ArrayObject([]);
        $result = Glb_Hash::append($processed, 'dad.is.rugbyman', 'allblack');
        $this->assertEquals($result, 'allblack', '#3 append(ao, result)');
        $this->assertEquals($processed, new ArrayObject(['dad' => ['is' => ['rugbyman' => 'allblack']]]), '#3 append(ao)');

        $result = Glb_Hash::append($processed, 'dad.is', 'aman');
        $this->assertEquals($result, ['aman', 'rugbyman' => 'allblack'], '#4 append(ao, result)');
        $this->assertEquals($processed, new ArrayObject(['dad' => ['is' => ['aman', 'rugbyman' => 'allblack']]]), '#4 append(ao)');

        $result = Glb_Hash::remove($processed, 'dad.is.aman');
        $this->assertEquals($result, null, '#5 append(ao, result)');
        $this->assertEquals($processed, new ArrayObject(['dad' => ['is' => ['aman', 'rugbyman' => 'allblack']]]), '#5 append(ao)');

        $result = Glb_Hash::remove($processed, 'dad.is.rugbyman');
        $this->assertEquals($result, 'allblack', '#6 append(ao, result)');
        $this->assertEquals($processed, new ArrayObject(['dad' => ['is' => ['aman']]]), '#6 append(ao)');

        $result = Glb_Hash::remove($processed, 'dad');
        $this->assertEquals($result, ['is' => ['aman']], '#7 append(ao, result)');
        $this->assertEquals($processed, new ArrayObject([]), '#7 append(ao)');

        // test Object
        $processed = new stdClass();
        $result = Glb_Hash::append($processed, 'mum', '32 teeth');
        $this->assertEquals($result, '32 teeth', '#1 append(o, result)');
        $this->assertEquals($processed, (object)(['mum' => '32 teeth']), '#1 append(o)');

        $result = Glb_Hash::append($processed, 'mum', 'all white');
        $this->assertEquals($result, ['32 teeth', 'all white'], '#2 append(o, result)');
        $this->assertEquals($processed, (object)(['mum' => ['32 teeth', 'all white']]), '#2 append(o)');

        $processed = new stdClass();
        $result = Glb_Hash::append($processed, 'dad.is.rugbyman', 'allblack');
        $this->assertEquals($result, 'allblack', '#3 append(o, result)');
        $this->assertEquals($processed, (object)(['dad' => ['is' => ['rugbyman' => 'allblack']]]), '#3 append(o)');

        $result = Glb_Hash::append($processed, 'dad.is', 'aman');
        $this->assertEquals($result, ['aman', 'rugbyman' => 'allblack'], '#4 append(o, result)');
        $this->assertEquals($processed, (object)(['dad' => ['is' => ['aman', 'rugbyman' => 'allblack']]]), '#4 append(o)');

        $result = Glb_Hash::remove($processed, 'dad.is.aman');
        $this->assertEquals($result, null, '#5 append(o, result)');
        $this->assertEquals($processed, (object)(['dad' => ['is' => ['aman', 'rugbyman' => 'allblack']]]), '#5 append(o)');

        $result = Glb_Hash::remove($processed, 'dad.is.rugbyman');
        $this->assertEquals($result, 'allblack', '#6 append(o, result)');
        $this->assertEquals($processed, (object)(['dad' => ['is' => ['aman']]]), '#6 append(o)');

        $result = Glb_Hash::remove($processed, 'dad');
        $this->assertEquals($result, ['is' => ['aman']], '#7 append(o, result)');
        $this->assertEquals($processed, new stdClass(), '#7 append(o)');

    }

    public function testUnderscorizeKeys() {


        $expected = ['mum_dad' => 'myParents', 'plugin_uri' => 'unknown', 'post_man_name_x' => 'theGuy'];
        $processed = ['mumDad' => 'myParents', 'Plugin_URI' => 'unknown', 'post-Man name$x' => 'theGuy'];
        $tests = [
            [ 'underscorize_keys()', ['Glb_Hash', 'underscorize_keys'], [$processed], $expected ],
            [ 'underscorize_keys()', ['Glb_Hash', 'underscorize_keys'], [new ArrayObject($processed)], new ArrayObject($expected) ],
            [ 'underscorize_keys()', ['Glb_Hash', 'underscorize_keys'], [(object)$processed], (object)$expected ],
            [ 'underscorize_keys()', ['Glb_Hash', 'underscorize_keys'], [(new Glb_Entity($processed))->to_array()], (new Glb_Entity($expected))->to_array() ],
        ];

        $this->_testBulkEquals($tests);

    }

    public function testEnsureValues() {
        $processed = array_fill (0, 5, ['x1' => 'don\'t touch me']);
        $tests = [
            [ 'ensureValues(a)', ['Glb_Hash', 'ensure_values'], [&$processed[0], ['x1', 'x2', 'x3'], 0], ['x1' => 'don\'t touch me', 'x2' => 0, 'x3' => 0]],
            [ 'ensureValues(a)', ['Glb_Hash', 'ensure_values'], [&$processed[1], ['x1', 'x2.y1.y2', 'x3'], 0], ['x1' => 'don\'t touch me', 'x2' => ['y1' => ['y2' => 0]], 'x3' => 0]],
            [ 'ensureValues(a)', ['Glb_Hash', 'ensure_values'], [&$processed[2], ['x1', 'x2', 'x3', 'x4'], [1, 2, 3]], ['x1' => 'don\'t touch me', 'x2' => 2, 'x3' => 3, 'x4' => 3]],
            [ 'ensureValues(a)', ['Glb_Hash', 'ensure_values'], [&$processed[3], ['x1', 'x2.y1.y2', 'x3', null], 0], ['x1' => 'don\'t touch me', 'x2' => ['y1' => ['y2' => 0]], 'x3' => 0, '' => 0]],
            [ 'ensureValues(a)', ['Glb_Hash', 'ensure_values'], [&$processed[4], ['x1', 'x2.y1.y2', 'x3', null], null], ['x1' => 'don\'t touch me', 'x2' => ['y1' => ['y2' => 0]], 'x3' => 0, '' => 0]],
        ];
        $this->_testBulkEquals($tests);

        $processed = [new ArrayObject(['x1' => 'don\'t touch me']), new ArrayObject(['x1' => 'don\'t touch me']), new ArrayObject(['x1' => 'don\'t touch me']), new ArrayObject(['x1' => 'don\'t touch me']), new ArrayObject(['x1' => 'don\'t touch me'])];
        $tests = [
            [ 'ensureValues(ao)', ['Glb_Hash', 'ensure_values'], [&$processed[0], ['x1', 'x2', 'x3'], 0], new ArrayObject(['x1' => 'don\'t touch me', 'x2' => 0, 'x3' => 0])],
            [ 'ensureValues(ao)', ['Glb_Hash', 'ensure_values'], [&$processed[1], ['x1', 'x2.y1.y2', 'x3'], 0], new ArrayObject(['x1' => 'don\'t touch me', 'x2' => ['y1' => ['y2' => 0]], 'x3' => 0])],
            [ 'ensureValues(ao)', ['Glb_Hash', 'ensure_values'], [&$processed[2], ['x1', 'x2', 'x3', 'x4'], [1, 2, 3]], new ArrayObject(['x1' => 'don\'t touch me', 'x2' => 2, 'x3' => 3, 'x4' => 3])],
            [ 'ensureValues(ao)', ['Glb_Hash', 'ensure_values'], [&$processed[3], ['x1', 'x2.y1.y2', 'x3', null], 0], new ArrayObject(['x1' => 'don\'t touch me', 'x2' => ['y1' => ['y2' => 0]], 'x3' => 0, '' => 0])],
            [ 'ensureValues(ao)', ['Glb_Hash', 'ensure_values'], [&$processed[4], ['x1', 'x2.y1.y2', 'x3', null], null], new ArrayObject(['x1' => 'don\'t touch me', 'x2' => ['y1' => ['y2' => 0]], 'x3' => 0, '' => 0])],
        ];
        $this->_testBulkEquals($tests);

        $processed = [(object)(['x1' => 'don\'t touch me']), (object)(['x1' => 'don\'t touch me']), (object)(['x1' => 'don\'t touch me']), (object)(['x1' => 'don\'t touch me']), (object)(['x1' => 'don\'t touch me'])];
        $tests = [
            [ 'ensureValues(o)', ['Glb_Hash', 'ensure_values'], [&$processed[0], ['x1', 'x2', 'x3'], 0], (object)(['x1' => 'don\'t touch me', 'x2' => 0, 'x3' => 0])],
            [ 'ensureValues(o)', ['Glb_Hash', 'ensure_values'], [&$processed[1], ['x1', 'x2.y1.y2', 'x3'], 0], (object)(['x1' => 'don\'t touch me', 'x2' => ['y1' => ['y2' => 0]], 'x3' => 0])],
            [ 'ensureValues(o)', ['Glb_Hash', 'ensure_values'], [&$processed[2], ['x1', 'x2', 'x3', 'x4'], [1, 2, 3]], (object)(['x1' => 'don\'t touch me', 'x2' => 2, 'x3' => 3, 'x4' => 3])],
            [ 'ensureValues(o)', ['Glb_Hash', 'ensure_values'], [&$processed[3], ['x1', 'x2.y1.y2', 'x3', null], 0], (object)(['x1' => 'don\'t touch me', 'x2' => ['y1' => ['y2' => 0]], 'x3' => 0, '' => 0])],
            [ 'ensureValues(o)', ['Glb_Hash', 'ensure_values'], [&$processed[4], ['x1', 'x2.y1.y2', 'x3', null], null], (object)(['x1' => 'don\'t touch me', 'x2' => ['y1' => ['y2' => 0]], 'x3' => 0, '' => 0])],
        ];
        $this->_testBulkEquals($tests);

        $processed = [(new Glb_Entity(['x1' => 'don\'t touch me']))->to_array(), (new Glb_Entity(['x1' => 'don\'t touch me']))->to_array(), (new Glb_Entity(['x1' => 'don\'t touch me']))->to_array(), (new Glb_Entity(['x1' => 'don\'t touch me']))->to_array(), (new Glb_Entity(['x1' => 'don\'t touch me']))->to_array()];
        $tests = [
            [ 'ensureValues(e)', ['Glb_Hash', 'ensure_values'], [&$processed[0], ['x1', 'x2', 'x3'], 0], (new Glb_Entity(['x1' => 'don\'t touch me', 'x2' => 0, 'x3' => 0]))->to_array()],
            [ 'ensureValues(e)', ['Glb_Hash', 'ensure_values'], [&$processed[1], ['x1', 'x2.y1.y2', 'x3'], 0], (new Glb_Entity(['x1' => 'don\'t touch me', 'x2' => ['y1' => ['y2' => 0]], 'x3' => 0]))->to_array()],
            [ 'ensureValues(e)', ['Glb_Hash', 'ensure_values'], [&$processed[2], ['x1', 'x2', 'x3', 'x4'], [1, 2, 3]], (new Glb_Entity(['x1' => 'don\'t touch me', 'x2' => 2, 'x3' => 3, 'x4' => 3]))->to_array()],
            [ 'ensureValues(e)', ['Glb_Hash', 'ensure_values'], [&$processed[3], ['x1', 'x2.y1.y2', 'x3', null], 0], (new Glb_Entity(['x1' => 'don\'t touch me', 'x2' => ['y1' => ['y2' => 0]], 'x3' => 0, '' => 0]))->to_array()],
            [ 'ensureValues(e)', ['Glb_Hash', 'ensure_values'], [&$processed[4], ['x1', 'x2.y1.y2', 'x3', null], null], (new Glb_Entity(['x1' => 'don\'t touch me', 'x2' => ['y1' => ['y2' => 0]], 'x3' => 0, '' => 0]))->to_array()],
        ];
        $this->_testBulkEquals($tests);

    }

    /*
    public function testFindPattern() {
    }

    public function testAttributes() {
    }

    public function testDuplicate() {
    }

    public function testMerge() {

    }
    */


}
