<?php

/**
 * The public-facing functionality of the plugin.
 *
 * @link       http://www.nowhere.nohow
 * @since      1.0.0
 *
 * @package    Gloubi_Boulga_Docxplorer
 * @subpackage Gloubi_Boulga_Docxplorer/public
 */

/**
 * The public-facing functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the public-facing stylesheet and JavaScript.
 *
 * @package    Gloubi_Boulga_Docxplorer
 * @subpackage Gloubi_Boulga_Docxplorer/public
 * @author     Gloubi <glb@glb.com>
 */
class Glb_Docx_Public extends Glb_Plugin_Bud {

    public function __construct($plugin) {

        parent::__construct($plugin);

        $this->plugin->add_route('glb-docx-connector', [$this, 'process_connector']);
        $this->plugin->add_shortcode( GLB_DOCX_SHORTCODE, [$this, 'glb_docx_shortcode'] );

        // WP admin access control
        if (Glb_Users::current_has_caps(GLB_DOCX_USER_CAPABILITY) &&
            !Glb_Users::current_has_caps([GLB_DOCX_ADMIN_CAPABILITY, 'administrator', 'manage_options'])) {
            $this->plugin->add_action( 'admin_init',     [$this, 'access_dashboard_redirect'] );
            //$this->plugin->add_action( 'admin_head',     [$this, 'access_hide_menus'] );
            $this->plugin->add_action( 'admin_bar_menu', [$this, 'access_hide_toolbar_items'], 999 );
        }

    }

    /**
     * redirects glb_docx_users to the home page if trying to load admin page wich is not "profile"
     */
    public function access_dashboard_redirect() {
        global $pagenow;
        if ( 'profile.php' != $pagenow ) {
            wp_redirect( home_url() );
            exit;
        }
    }

    /**
     * hide admin menus to glb_docx_users if allow_admin_bar setting is false
     */
    public function access_hide_menus() {
        /*global $menu;
        return;

        if ($this->plugin->settings->get_value('allow_admin_bar')) {
            return;
        }

        glb_dump($menu);
        foreach ( $menu as $index => $values ) {
            if ( isset( $values[2] ) ) {
                if (!('profile.php' == $values[2] && $this->plugin->settings->get_value('allow_profile'))) {
                    remove_menu_page( $values[2] );
                }
            }
        }*/
    }

    /**
     * Hide toolbar items if allow_admin_bar setting is false
     * @param $wp_admin_bar
     */
    public function access_hide_toolbar_items($wp_admin_bar) {
        $allowed = [
            'top-secondary' => ['my-account'],
            'my-account' => ['user-actions'],
            'user-actions' => [ 'user-info', 'edit-profile', 'logout', 'switch-back'],
            'menu-toggle' => true,
            'languages' => true,
            'site-name' => [],
        ];

        if ( !is_object( $wp_admin_bar ) ) {
            return;
        }


        // Clean the AdminBar
        $nodes = $wp_admin_bar->get_nodes();
        foreach( $nodes as $node )
        {
            if (!$node->parent && array_key_exists($node->id, $allowed)) {
                continue;
            }
            if ( $node->parent && array_key_exists($node->parent, $allowed) &&
                ($allowed[$node->parent] === true || in_array($node->id, $allowed[$node->parent])) ) {
                continue;
            }
            $wp_admin_bar->remove_menu( $node->id );
        }
    }

    public function glb_docx_shortcode($param, $content) {

        if (!is_user_logged_in()) {
            return $this->plugin->render_template('core:elements/glb-core-login-form', null, true);
        } else if (!Glb_Users::current_has_caps(GLB_DOCX_USER_CAPABILITY)) {
            return __glb('Sorry but you can\'t access this content.');
        } else {
            return $this->plugin->render_template('elements/glb-docx-shortcode', [], true);
        }
    }

    public function process_connector($params) {
        // check json query


        $command = $this->request->get_post_or_get('cmd');

        //Glb_Log::info('process_connector1 ' . $command . ' ' . print_r($this->request->get_post_or_get('targets'), true));
        Glb_Log::notice('process_connector responseCode2(1) ', $command);
        Glb_Log::notice('process_connector responseCode2(2) ', $this->plugin->settings->get_value('elfinder_commands'));
        if (!in_array($command, explode(' ', $this->plugin->settings->get_value('elfinder_commands')))) {
            Glb_Log::notice('process_connector responseCode2(3) COMMAND NOT FOUND ', $command);
            //$this->plugin->request->set_json_error('403', 'redirect:referer', true);
            $this->plugin->request->set_json_error('403', 'status:set', true);
            return;
        }
        if (!Glb_Users::current_has_caps(GLB_DOCX_USER_CAPABILITY) ||
            empty($command) ||
            !in_array($command, explode(' ', $this->plugin->settings->get_value('elfinder_commands'))) ) {
            $this->plugin->request->set_json_error('403', 'status:set', true);
            return;
        }

        $this->request->check_nonce("glb_nonce_$command", "glb_nonce_$command");

        Glb_Log::notice('process_connector http_response_code ' . http_response_code());
        status_header(200);
        http_response_code(200);

        //if ( isset( $wp_query->query_vars['glb-docx-connector'] ) ) {
        //Glb_Log::notice('responseCode2(2) ', http_response_code());
        require_once $this->plugin->file_path('vendors', 'studio-42', 'elfinder', 'php', 'autoload.php');
        require_once $this->plugin->file_path('vendors', 'studio-42', 'elfinder', 'php', 'elFinderConnector.class.php');
        require_once $this->plugin->file_path('vendors', 'studio-42', 'elfinder', 'php', 'elFinder.class.php');
        require_once $this->plugin->file_path('vendors', 'studio-42', 'elfinder', 'php', 'elFinderVolumeDriver.class.php');
        require_once $this->plugin->file_path('vendors', 'studio-42', 'elfinder', 'php', 'elFinderVolumeLocalFileSystem.class.php');

        $this->plugin->render_template('glb-docx-connector');
    }

}