
(function(){
    "use strict";
    var // jQuery and jQueryUI version
        jqver = '3.3.1',
        uiver = '1.12.1',

        // Detect language (optional)
        lang = glb_docx_language,

        // Start elFinder (REQUIRED)
        start = function(elFinder, editors, config) {
            // load jQueryUI CSS
            elFinder.prototype.loadCss('//cdnjs.cloudflare.com/ajax/libs/jqueryui/'+uiver+'/themes/smoothness/jquery-ui.css');

            $(function() {
                var optEditors = {
                        commandsOptions: {
                            edit: {
                                editors: Array.isArray(editors)? editors : []
                            }
                        }
                    },
                    opts = {};

                // Interpretation of "elFinderConfig"
                if (config && config.managers) {
                    $.each(config.managers, function(id, mOpts) {
                        opts = Object.assign(opts, config.defaultOpts || {});
                        // editors marges to opts.commandOptions.edit
                        try {
                            mOpts.commandsOptions.edit.editors = mOpts.commandsOptions.edit.editors.concat(editors || []);
                        } catch(e) {
                            Object.assign(mOpts, optEditors);
                        }
                        // Make elFinder
                        var instance = $('#' + id).elfinder(
                            // 1st Arg - options
                            $.extend(true, { lang: lang, width: '100%', height: $(window).height() }, opts, mOpts || {}),
                            // 2nd Arg - before boot up function
                            function(fm, extraObj) {
                                // `init` event callback function
                                fm.bind('init', function() {
                                    // Optional for Japanese decoder "encoding-japanese"
                                    if (fm.lang === 'ja') {
                                        require(
                                            [ 'encoding-japanese' ],
                                            function(Encoding) {
                                                if (Encoding && Encoding.convert) {
                                                    fm.registRawStringDecoder(function(s) {
                                                        return Encoding.convert(s, {to:'UNICODE',type:'string'});
                                                    });
                                                }
                                            }
                                        );
                                    }
                                });
                            }
                        );
                    });
                } else {
                    alert('"elFinderConfig" object is wrong.');
                }
            });
        },

        // JavaScript loader (REQUIRED)
        load = function() {
            require(
                [
                    'elfinder',
                    glb_elfinder_editors_path,
                    'elFinderConfig',
                    //'//localhost/wordpress/wp-content/plugins/gloubi-boulga-docxplorer/vendors/studio-42/elfinder/js/extras/docxplorer.sharefolder' // load text, image editors
                    //	, 'extras/quicklook.googledocs.min'          // optional preview for GoogleApps contents on the GoogleDrive volume
                ],
                start,
                function(error) {
                    alert(error.message);
                }
            );
        },

        // is IE8 or :? for determine the jQuery version to use (optional)
        old = (typeof window.addEventListener === 'undefined' && typeof document.getElementsByClassName === 'undefined')
            ||
            (!window.chrome && !document.unqueID && !window.opera && !window.sidebar && 'WebkitAppearance' in document.documentElement.style && document.body.style && typeof document.body.style.webkitFilter === 'undefined');

    // config of RequireJS (REQUIRED)
    require.config({
        baseUrl : 'js',
        paths : {
            'jquery'   : '//cdnjs.cloudflare.com/ajax/libs/jquery/'+(old? '1.12.4' : jqver)+'/jquery.min',
            'jquery-ui': '//cdnjs.cloudflare.com/ajax/libs/jqueryui/'+uiver+'/jquery-ui.min',
            'elfinder': glb_elfinder_path, // load text, image editors
            'encoding-japanese': '//cdn.rawgit.com/polygonplanet/encoding.js/1.0.26/encoding.min'
        },
        waitSeconds : 10 // optional
    });

    // check elFinderConfig and fallback
    // This part don't used if you are using elfinder.html, see elfinder.html
    /*if (! require.defined('elFinderConfig')) {
        define('elFinderConfig', {
            // elFinder options (REQUIRED)
            // Documentation for client options:
            // https://github.com/Studio-42/elFinder/wiki/Client-configuration-options
            defaultOpts : {
                url : 'connector.minimal.php' // connector URL (REQUIRED)
                ,commandsOptions : {
                    edit : {
                        extraOptions : {
                            // set API key to enable Creative Cloud image editor
                            // see https://console.adobe.io/
                            creativeCloudApiKey : '',
                            // browsing manager URL for CKEditor, TinyMCE
                            // uses self location with the empty value
                            managerUrl : ''
                        }
                    }
                    ,quicklook : {
                        // to enable CAD-Files and 3D-Models preview with sharecad.org
                        sharecadMimes : ['image/vnd.dwg', 'image/vnd.dxf', 'model/vnd.dwf', 'application/vnd.hp-hpgl', 'application/plt', 'application/step', 'model/iges', 'application/vnd.ms-pki.stl', 'application/sat', 'image/cgm', 'application/x-msmetafile'],
                        // to enable preview with Google Docs Viewer
                        googleDocsMimes : ['application/pdf', 'image/tiff', 'application/vnd.ms-office', 'application/msword', 'application/vnd.ms-word', 'application/vnd.ms-excel', 'application/vnd.ms-powerpoint', 'application/vnd.openxmlformats-officedocument.wordprocessingml.document', 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet', 'application/vnd.openxmlformats-officedocument.presentationml.presentation', 'application/postscript', 'application/rtf'],
                        // to enable preview with Microsoft Office Online Viewer
                        // these MIME types override "googleDocsMimes"
                        officeOnlineMimes : ['application/vnd.ms-office', 'application/msword', 'application/vnd.ms-word', 'application/vnd.ms-excel', 'application/vnd.ms-powerpoint', 'application/vnd.openxmlformats-officedocument.wordprocessingml.document', 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet', 'application/vnd.openxmlformats-officedocument.presentationml.presentation', 'application/vnd.oasis.opendocument.text', 'application/vnd.oasis.opendocument.spreadsheet', 'application/vnd.oasis.opendocument.presentation']
                    }
                }
            },
            managers : {
                'elfinder': {},
            }
        });
    }*/

    // load JavaScripts (REQUIRED)
    load();

})();
