jQuery(document).ready(function () {
    //var security_key = docx_params.glb_nonce;

    jQuery('#glb-elfinder').elfinder({
        url: docx_params.ajax_url,
        customData: docx_params.custom_data, /*{
            action: 'mk_file_folder_manager',
            glb_nonce: security_key
        },*/
        uploadMaxChunkSize: 1048576000000,
        defaultView: 'list',
        height: jQuery(window).height() - 20,
        lang: docx_params.lang,
        i18nBaseUrl: docx_params.i18n_base_url,
        /* Start */
        handlers: {
            /* Upload */
            /*upload: function (event, instance) {
                if (docx_params.enable_upload) {
                    var filepaths = [];
                    var uploadedFiles = event.data.added;
                    for (i in uploadedFiles) {
                        var file = uploadedFiles[i];
                        filepaths.push(file.url);
                    }
                    if (filepaths != '') {
                        var data = {
                            //'action': 'mk_file_folder_manager_media_upload',
                            'uploadefiles': filepaths
                        };
                        jQuery.post(ajax_url, data, function (response) {

                        });
                    }
                }
            },*/
        },
        commandsOptions : {
            edit : {
                extraOptions : {
                    creativeCloudApiKey : '',
                    managerUrl : ''
                }
            },
            quicklook : {
                sharecadMimes : ['image/vnd.dwg', 'image/vnd.dxf', 'model/vnd.dwf', 'application/vnd.hp-hpgl', 'application/plt', 'application/step', 'model/iges', 'application/vnd.ms-pki.stl', 'application/sat', 'image/cgm', 'application/x-msmetafile'],
                googleDocsMimes : ['application/pdf', 'image/tiff', 'application/vnd.ms-office', 'application/msword', 'application/vnd.ms-word', 'application/vnd.ms-excel', 'application/vnd.ms-powerpoint', 'application/vnd.openxmlformats-officedocument.wordprocessingml.document', 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet', 'application/vnd.openxmlformats-officedocument.presentationml.presentation', 'application/postscript', 'application/rtf'],
                officeOnlineMimes : ['application/vnd.ms-office', 'application/msword', 'application/vnd.ms-word', 'application/vnd.ms-excel', 'application/vnd.ms-powerpoint', 'application/vnd.openxmlformats-officedocument.wordprocessingml.document', 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet', 'application/vnd.openxmlformats-officedocument.presentationml.presentation', 'application/vnd.oasis.opendocument.text', 'application/vnd.oasis.opendocument.spreadsheet', 'application/vnd.oasis.opendocument.presentation']
            }
        },
        // bootCalback calls at before elFinder boot up
        bootCallback : function(fm, extraObj) {
            /* any bind functions etc. */
            fm.bind('init', function() {
                console.log('elfinder inited');
            });
            // for example set document.title dynamically.
            var title = document.title;
            fm.bind('open', function() {
                var path = '',
                    cwd  = fm.cwd();
                if (cwd) {
                    path = fm.path(cwd.hash) || null;
                }
                document.title = path? path + ':' + title : title;
            }).bind('destroy', function() {
                document.title = title;
            });
        },
        commands : docx_params.commands,
        getFileCallback : function(file, elFinderInstance) {
            var url = file.url;
            var absoluteUrl = elFinderInstance.convAbsUrl(url);
            console.log('getFileCallback');
        },
        upload : function(event, instance) {
            console.log('upload');
        },
        uiOptions : {
            // toolbar configuration
            toolbar: docx_params.toolbar,
            toolbar_backup : [
                ['home', 'back', 'forward', 'up', 'reload'],
                ['netmount'],
                ['mkdir', 'mkfile', 'upload'],
                ['open', 'download', 'getfile'],
                ['undo', 'redo'],
                ['copy', 'cut', 'paste', 'rm', 'empty', 'hide'],
                ['duplicate', 'rename', 'edit', 'resize', 'chmod'],
                ['selectall', 'selectnone', 'selectinvert'],
                ['quicklook', 'info'],
                ['extract', 'archive'],
                ['search'],
                ['view', 'sort'],
                ['preference', 'help'],
                ['fullscreen']
            ],

            // directories tree options
            tree : {
                // expand current root on init
                openRootOnLoad : true,
                // auto load current dir parents
                syncTree : true
            },

            // navbar options
            navbar : {
                minWidth : 150,
                maxWidth : 500
            },

            // current working directory options
            cwd : {
                // display parent directory in listing as ".."
                oldSchool : false
            }
        },
        contextmenu : {
            // navbarfolder menu
            navbar: docx_params.navbar,
            navbar_backup : ['open', '|', 'copy', 'cut', 'paste', 'duplicate', '|', 'rm', '|', 'info'],

            // current directory menu
            cwd: docx_params.cwd,
            cwd_backup    : ['reload', 'back', '|', 'upload', 'mkdir', 'mkfile', 'paste', '|', 'info'],

            // current directory file menu
            files: docx_params.files,
            files_backup    : ['getfile', '|', 'open', 'quicklook', '|', 'download', '|', 'copy', 'cut', 'paste', 'duplicate', '|', 'rm', '|', 'edit', 'rename', 'resize', '|', 'archive', 'extract', '|', 'info']
        },

        /* END */
    }).elfinder('instance');

    var resizeTimer = null;
    var onWindowResize = function() {
        resizeTimer && clearTimeout(resizeTimer);
        resizeTimer = setTimeout(function() {
            var elfinder = jQuery('#glb-elfinder');
            if (elfinder && elfinder.offset()) {
                console.log('resize');
                console.log(jQuery(window).height());
                console.log(elfinder.offset().top);
                var h = parseInt(jQuery(window).height()) - elfinder.offset().top - 10;
                h = Math.max(500, h);
                if (h != parseInt(elfinder.height())) {
                    elfinder.elfinder('instance').resize('100%', h);
                }
            }
        }, 200);
    };

    jQuery(window).resize(onWindowResize);
    onWindowResize();
});