<?php

/** ------------------------------------------------------------------------
 * Gloubi Boulga DocXplorer plugin bootstrap file
 *
 * This file is the entry point of this plugin. It also includes all of its
 * dependencies. The following comments are not only comments, they are used
 * by WordPress to display the plugin information in the plugin admin area.
 * They are also used by Gloubi Boulga's Core plugin to identify his child.
 * In this file, please don't call Gloubi Boulga's Core functions. May be they are
 * not already loaded yet !
 *
 * @link                    http://www.nowhere.nohow
 * @since                   1.0.0
 * @package                 Gloubi_Boulga_Docxplorer
 *
 * @wordpress-plugin
 * Plugin Name:             Glb DocXplorer
 * Glb Alias:               DocX
 * Plugin URI:              http://www.nowhere.nohow
 * Description:             This is a short description of what the plugin does. It's displayed in the WordPress admin area.
 * Version:                 0.0.2
 * Author:                  Gloubi
 * Author URI:              http://www.nowhere.nohow
 * License:                 Not really sure yet
 * License URI:             http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:             glb-docx
 * Domain Path:             /langs
 * Priority:                5
------------------------------------------------------------------------ */

// If this file is called directly, abort.
if ( !defined('WPINC') ) {
    die;
}

define('GLB_DOCX_ADMIN_CAPABILITY', 'glb_docxplorer_admin');
define('GLB_DOCX_USER_CAPABILITY', 'glb_docxplorer_access');
define('GLB_DOCX_ADMIN_ROLE', 'glb_docxplorer_admin');
define('GLB_DOCX_USER_ROLE', 'glb_docxplorer_user');
define('GLB_DOCX_SHORTCODE', 'glb_docxplorer');

// Need to ensure that session is started for docxplorer

if (empty(session_id()) && !headers_sent()) {
    try { session_start(); } catch(Exception $ex) { }
}


// Include required files
define('GLB_DOCX_PATH', plugin_dir_path(__FILE__));
require_once GLB_DOCX_PATH . 'controllers/class-glb-docx-repos.php';


// Start plugin execution at plugins_loaded hook (where you can set the priority of your plugin)
add_action('plugins_loaded', function() {
    require_once GLB_DOCX_PATH . 'controllers/class-glb-docx.php';
    (new Glb_Docx())->run();
    /*$permissions = Glb_Table::get('permissions');
    $query = $permissions->query('select')
        ->contain('docx_repos')
        ->fields(['num' => 'id', 'descriptionX' => 'concat(user_id, "-", repo_id)', 'Permissions.*'])
        //->where(['docx_repos.name LIKE' => '%a%'])
        ->limit(50)
        ->execute();
    glb_dump($query);*/
}, 2);

// register activation process
function glb_docx_activate() {
    require_once WP_PLUGIN_DIR . '/gloubi-boulga/gloubi-boulga.php';
    require_once GLB_DOCX_PATH . 'controllers/class-glb-docx.php';
    require_once GLB_DOCX_PATH . 'controllers/class-glb-docx-installer.php';
    (new Glb_Docx())->activate();
}
register_activation_hook( __FILE__, 'glb_docx_activate');

// register deactivation process
function glb_docx_deactivate() {
    require_once WP_PLUGIN_DIR . '/gloubi-boulga/gloubi-boulga.php';
    require_once GLB_DOCX_PATH  . 'controllers/class-glb-docx-installer.php';
    require_once GLB_DOCX_PATH . 'controllers/class-glb-docx.php';
    (new Glb_Docx())->deactivate();
}
register_deactivation_hook( __FILE__, 'glb_docx_deactivate');

// register uninstall process
function glb_docx_uninstall() {
    require_once WP_PLUGIN_DIR . '/gloubi-boulga/gloubi-boulga.php';
    require_once GLB_DOCX_PATH . 'controllers/class-glb-docx-installer.php';
    (new Glb_Docx_Installer())->uninstall();
}
register_uninstall_hook( __FILE__, 'glb_docx_uninstall');
