<?php

glb_check_wpinc();

Glb_Table::hook('core_users', 'many_to_many', 'docx_repos', [
    // @todo : table must not be mandatory
    "table" => "docx_repos",
    "through" => [
        "table" => "docx_permissions",
        "alias" => "docx_repos_permissions"
    ],
    "conditions" => [
    ],
    "binding_key" => ["ID" => "user_id"],
    "foreign_key" => ["repo_id" => "id"],
    'property' => 'repos'
]);

Glb_Table::hook('core_users', 'many_to_many', 'allowed_repos', [
    "table" => "docx_repos",
    "through" => [
        "table" => "docx_permissions",
        "alias" => "docx_allowed_repos_permissions"
    ],
    "conditions" => [],
    "binding_key" => ["ID" => "user_id"],
    "foreign_key" => ["repo_id" => "id"],
    'property' => 'allowed_repos'
]);

Glb_Table::hook('core_users', 'one_to_many', 'docx_permissions', [
    "binding_key" => "ID",
    "foreign_key" => "user_id",
    'property' => 'permissions'
]);

Glb_Table::hook('core_logs', 'many_to_one', 'docx_repos', [
    "table" => "docx_repos",
    "conditions" => [ 'element_type' => 'repository' ],
    'binding_key' => 'element_id',
    'property' => 'repos'
]);
