<?php

class Glb_Docx_Repos_Table extends Glb_Table {

    public function initialize($options) {

        $this->add_behavior('timestamp');

        $this->many_to_many('core_users', [
            "through" => [
                "table" => "docx_permissions",
                "alias" => "docx_repos_permissions"
            ],
            "conditions" => [
                "'special' = 'special'"
            ],
            "binding_key" => ["id" => "repo_id"],
            "foreign_key" => ["user_id" => "ID"],
            "property" => 'users',
        ]);

        /*$this->many_to_many('matching_users', [
            'table' => 'core_users',
            "through" => [
                "table" => "docx_permissions",
                "alias" => "docx_matching_repos_permissions"
            ],
            "conditions" => [
                "'matching' = 'matching'"
            ],
            "binding_key" => ["id" => "repo_id"],
            "foreign_key" => ["user_id" => "ID"],
            "property" => 'matching_users'
        ]);*/

        $this->one_to_many('docx_permissions', [
            //'class' => 'docx_permissions',
            'property' => 'permissions',
            'foreign_key' => 'repo_id',
            'binding_key' => 'id',
            //'update_keys' => ['repo_id', 'user_id'],
        ]);

    }

    public function before_select($query, $event, $options) {
        if ($event->is_primary()) {
            $query->where(["'docx_repos_before_select'='docx_repos_before_select'"]);
        } else {
            $event->relation()->add_conditions(["'docx_repos_before_select'='docx_repos_before_select'"]);
        }
    }

}
