<?php

if (!defined('WPINC')) {
    die;
}


class elDocxFinder extends elFinder {
    // Custom error message if description isn't found
    const ERROR_DESC_NOT_FOUND = 'Description not found';

    // Run the old constructor and register 'desc' as a new command
    public function __construct($opts) {
        parent::__construct($opts);
    }

}

$roots = array();

$upload_allow = array(
    // images
    'image/x-ms-bmp', 'image/bmp', 'image/gif', 'image/jpeg', 'image/png', 'image/x-icon',
    // desktop apps
    'text/plain', 'application/msword', 'application/pdf', 'application/mspowerpoint', 'application/vnd.ms-powerpoint',
    'application/powerpoint', 'application/x-mspowerpoint', 'application/vnd.openxmlformats-officedocument.wordprocessingml.document',
    'application/vnd.openxmlformats-officedocument.presentationml.presentation', 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',
    'application/vnd.ms-excel',
    // medias
    'application/x-troff-msvideo', 'video/avi', 'video/msvideo', 'video/x-msvideo', 'video/mpeg', 'video/quicktime', 'audio/mpeg3', 'audio/x-wav',
    // zips
    'application/zip', 'application/x-gzip', 'multipart/x-gzip', 'application/x-gtar', 'application/x-compressed', 'application/x-bzip2',
    'application/x-zip-compressed', 'application/x-rar-compressed', 'application/x-tar', 'application/x-7z-compressed'
);

$trash_hash = null;

if ($plugin->settings->get_value('enable_trash')) {

    $roots[] = array(
        'id'            => 'id[0]',
        'driver'        => 'Trash',
        'path'          => Glb_Docx_Repos::full_path('_Trash'),
        'winHashFix'    => GLB_SEPARATOR !== '/', // to make hash same to Linux one on windows too
        'uploadDeny'    => array('all'),                // Recomend the same settings as the original volume that uses the trash
        'uploadAllow'   => $upload_allow,
        'uploadOrder'   => array('deny', 'allow'),      // Same as above
        'attributes' => array(
            array(
                'pattern' => '/$/',
                'read' => Glb_Users::current_has_caps(GLB_DOCX_ADMIN_CAPABILITY),
                'write' => 1,
                'locked' => 0,
                'hidden' => !Glb_Users::current_has_caps(GLB_DOCX_ADMIN_CAPABILITY)
            ),
        ),
    );

    $trash_hash = 'tid[0]_Lw';
}


$repos = [];

/*$cmd = $this->request->get_post_or_get('cmd');
if ($cmd == 'subdirs') {
    foreach($this->request->get_post_or_get('targets') as $file) {
        $id = Glb_Text::between($file, 'id[', ']');
        $repo = Glb_Docx_Repos::get($id);
        $repos[$repo->folder] = $repo;
    }
} else if ($cmd == 'open') {
    if (!empty($this->request->get_post_or_get('target'))) {
        $id = Glb_Text::between($this->request->get_post_or_get('target'), 'id[', ']');
        $repo = Glb_Docx_Repos::get($id);
        $repos[$repo->folder] = $repo;
    }
}*/

/*
For using folders as repositories
*/

if (empty($repos)) {
    $repos = Glb_Docx_Repos::get_all();
}

Glb_Log::info($repos);

foreach ($repos as $repo) {

    if (Glb_Users::current_has_caps(GLB_DOCX_ADMIN_CAPABILITY)) {
        $read = true;
        $write = true;
        $locked = false;
        $hidden = false;
    } else {
        Glb_Log::notice('$repo->my_permissions ' . $repo->my_permissions);
        $read = (strpos($repo->my_permissions, 'r') !== false);
        $write = (strpos($repo->my_permissions, 'w') !== false);
        $locked = (!$write);
        $hidden = (!$write && !$read);
    }

    $attributes = array(
        array(
            // hide folders starting with dot for non admins
            'pattern' => '/^\/\./',
            'read' => false, //Glb_Users::current_has_caps(['manage_options', GLB_DOCX_ADMIN_CAPABILITY]),
            'write' => false, //Glb_Users::current_has_caps(['manage_options', GLB_DOCX_ADMIN_CAPABILITY]),
            'locked' => true, //!Glb_Users::current_has_caps(['manage_options', GLB_DOCX_ADMIN_CAPABILITY]),
            'hidden' => true, //!Glb_Users::current_has_caps(['manage_options', GLB_DOCX_ADMIN_CAPABILITY]),
        ),
        array(
            // set root folder permissions
            'pattern' => '/$/',
            'read' => $read,
            'write' => $write,
            'locked' => $locked,
            'hidden' => $hidden
        ),
    );

    $roots[] = array(
        'debug'         => true,
        'id'            =>  'id[' . $repo->id . ']',
        'driver'        => 'LocalFileSystem',                   // driver for accessing file system (REQUIRED)
        'path'          => $repo->full_path,                    // path to files (REQUIRED)
        //'URL'           => Glb_Path::concat([Glb_Plugin::get_registered('gloubi-boulga-docxplorer')->wp_uri, 'repositories', $repo['name']]), // URL to files (REQUIRED)
        //'tmbURL'        => Glb_Path::concat([Glb_Plugin::get_registered('gloubi-boulga-docxplorer')->wp_uri, 'repositories/.trash'], ['type' => 'url']) . '/',
        'tmbPath'         => null,
        'trashHash'     => $trash_hash,                             // elFinder's hash of trash folder
        'winHashFix'    => GLB_SEPARATOR !== '/',         // to make hash same to Linux one on windows too
        'uploadDeny'    => array('all'),                        // All Mimetypes not allowed to upload
        'uploadAllow'   => $upload_allow,
        'uploadOrder'   => array('deny', 'allow'),
        //'accessControl' => 'accessControl',                     // disable and hide dot starting files (OPTIONAL)
        'attributes' => $attributes,
    );

}

function activityLogCallback($cmd, $result, $args, $elfinder) {

    /*$log = sprintf('[%s] %s:', date('r'), strtoupper($cmd));
    foreach ($result as $key => $value) {
        if (empty($value)) {
            continue;
        }
        $data = array();
        if (in_array($key, array('error', 'warning'))) {
            array_push($data, implode(' ', $value));
        } else {
            if (is_array($value)) { // changes made to files
                foreach ($value as $file) {
                    $filepath = (isset($file['realpath']) ? $file['realpath'] : $elfinder->realpath($file['hash']));
                    array_push($data, $filepath);
                }
            } else { // other value (ex. header)
                array_push($data, $value);
            }
        }
        $log .= sprintf(' %s(%s)', $key, implode(', ', $data));
    }
    $log .= "\n";


    if (!empty($args['target'])) {

        $target_file = Glb_Docx_Repos::get_file_from_hash($args['target'], $elfinder);
        //$repo_folder = basename($elfinder->getVolume($args['target'])->getRootPath());

    } elseif (!empty($args['targets']) && is_array($args['targets']) && count($args['targets']) > 0) {

        $target_file = Glb_Docx_Repos::get_file_from_hash($args['targets'][0], $elfinder);

    }
    /*if (!empty($args['target'])) {
        $target_path = basename($elfinder->realpath($args['target']));
    }*/


    Glb_Log::notice('$cmd ', $cmd);
    Glb_Log::notice('$args ', $args);

    if ($cmd == 'zipdl' && !empty($args['download'])) {
        return;
    }
    //Glb_Log::notice('$result ', $result);
    $target_files = [];
    if (!empty($args['target'])) {
        $target_files = [Glb_Docx_Repos::get_from_hash($args['target'], $elfinder)];
    } elseif (!empty($args['targets']) && is_array($args['targets']) && count($args['targets']) > 0) {
        $target_files = Glb_Docx_Repos::get_from_hash($args['targets'], $elfinder);
    }

    Glb_Log::notice('$target_files ', $target_files);
    if (empty($target_files)) {
        return;
    }

    $log_labels = array(
        'archive' => __glbr('Zipped : %s created from %s'),
        'copy' => __glbr('Copied : %s'),
        'cut' => __glbr('Cut : %s '),
        'download' => __glbr('Downloaded : %s'),
        'duplicate' => __glbr('Duplicated : from %s to %s'),
        'edit' => __glbr('Edited : %s'),
        'extract' => __glbr('Extracted : %s'),
        'getfile' => __glbr('GetFile : %s'),
        'ls' => __glbr('Ls : %s'),
        'mkdir' => __glbr('Created : %s'),
        'mkfile' => __glbr('Created : %s'),
        'paste' => __glbr('Copied : from %s to %s'),
        '_move' => __glbr('Moved : %s from %s to %s'),
        'places' => __glbr('!!!! places'),
        'quicklook' => __glbr('Quicklooked : %s'),
        'reload' => __glbr('!!!! reload'),
        'rename' => __glbr('Renamed : from %s to %s'),
        '_rename_dir' => __glbr('Renamed : from %s to %s'),
        'restore' => __glbr('Restored : %s'),
        'rm' => __glbr('Deleted : %s'),
        'upload' => __glbr('Uploaded : %s'),
        'view' => __glbr('Viewed : %s'),
        'zipdl' => __glbr('Zip downloaded : %s'),
        'file' => __glbr('Downloaded : %s'),
        'get' => __glbr('!!!! get'),
    );


    function docx_format_path($repo, $folder) {
        return '[' . $repo . ']/' . $folder;
    }

    foreach($target_files as $target_file) {
        $repo = Glb_Docx_Repos::get_by('name', $target_file['repo_folder']);
        if (empty($repo)) { return; }
        $repo = $repo[0];

        if (empty($repo->id)) { return; }


        $label = $log_labels[$cmd];

        //Glb_Log::notice('activityLogCallback $cmd ', $cmd);
        //Glb_Log::notice('activityLogCallback $label ', $label);

        $params = [];

        if ($cmd == 'rename') {

            if (!empty($result['removed'][0]['dirs']) || $result['removed'][0]['mime'] == 'directory') {
                $label = $log_labels['_rename_dir'];
            }

            $path = Glb_Path::diff($result['removed'][0]['realpath'], $repo->full_path);
            $added = Glb_Docx_Repos::get_from_hash($result['added'][0]['hash'], $elfinder);
            $params = [docx_format_path($target_file['repo_folder'], $path), $added['relative_path_for_display']];

        } elseif (in_array($cmd, ['mkdir', 'mkfile', 'file'])) {

            //$file = Glb_Docx_Repos::get_file_from_hash($args['target'], $elfinder);
            if (!empty($args['name'])) {
                $params = [docx_format_path($target_file['repo_folder'], $target_file['relative_path_from_repo'] . '/' . $args['name'])];
            } else {
                $params = [$target_file['relative_path_for_display']];
            }

        } elseif (in_array($cmd, ['upload'])) {

            $file_list = [];
            foreach($result['added'] as $file) {
                $file = Glb_Docx_Repos::get_from_hash($file['hash'], $elfinder);
                $file_list[] = $file['relative_path_for_display'];
            }
            $params = [ join(', ', $file_list) ] ;

        } elseif (in_array($cmd, ['duplicate'])) {

            $params = [$target_file['relative_path_for_display'], $result['added'][0]['name']];

        } elseif (in_array($cmd, ['paste'])) {

            // its a cut and paste, or a move
            if (!empty($result['changed'][0]['hash']) && !empty($result['added'][0]['hash']) && !empty($result['removed'][0]['hash'])) {

                $label = $log_labels['_move'];

                $removed = Glb_Docx_Repos::get_from_hash($result['removed'][0]['phash'], $elfinder);
                $changed = Glb_Docx_Repos::get_from_hash($result['changed'][0]['hash'], $elfinder);
                $added = Glb_Docx_Repos::get_from_hash($result['added'][0]['hash'], $elfinder);
                $params = [$added['base_name'], $removed['relative_path_for_display'], docx_format_path($added['repo_folder'], $changed['relative_path_from_repo'])];

            } else if (!empty($result['changed'][0]['hash']) && !empty($result['added'][0]['hash'])) {

                $added = Glb_Docx_Repos::get_from_hash($result['added'][0]['hash'], $elfinder);
                $params = [$target_file['relative_path_for_display'], $added['relative_path_for_display']];

            }
        } elseif (in_array($cmd, ['rm'])) {

            $file_list = [];
            foreach($result['removed'] as $file) {
                $file = Glb_Docx_Repos::relative_path($file['realpath']);
                $file = Glb_Path::explode($file);
                $file_list[] = '[' . array_shift($file) . ']' . GLB_SEPARATOR . Glb_Path::concat($file);
            }
            $params = [ join(', ', $file_list) ] ;

        } elseif (in_array($cmd, ['zipdl'])) {

            $file_list = [];
            foreach($args['targets'] as $file) {
                $file = Glb_Docx_Repos::get_from_hash($file, $elfinder);
                $file_list[] = $file['relative_path_for_display'];
            }
            $params = [ join(', ', $file_list) ] ;

        } elseif (in_array($cmd, ['archive'])) {

            $added = [];
            foreach($result['added'] as $file) {
                $file = Glb_Docx_Repos::get_from_hash($file['hash'], $elfinder);
                $added[] = $file['relative_path_for_display'];
            }
            $targets = [];
            foreach($args['targets'] as $file) {
                $file = Glb_Docx_Repos::get_from_hash($file, $elfinder);
                $targets[] = $file['relative_path_for_display'];
            }
            $params = [ join(', ', $added), join(', ', $targets) ] ;

        }
        Glb_Db_Log::instance()->log('docx_' . $cmd, GLB_ACTIVITY_TYPE_USER_ACTION, [$label, $params], null, 'info');

    }

}

$opts = array(
    'bind' => array(
        'ls mkdir mkfile rename duplicate upload rm zipdl paste file paste archive download edit extract getfile places quicklook reload restore rm view get' => 'activityLogCallback'
        //'mkdir mkfile rename duplicate upload rm paste' => 'activityLogCallback'
        //'duplicate upload rm paste' => 'activityLogCallback'
    ),
    'roots' => $roots,
    'sessionCloseEarlier' => false
);

$el_finder = new elDocxFinder($opts);
$connector = new elFinderConnector($el_finder, false);  // instantiate using our custom elFinder object

//Glb_Log::notice('elFinderConnector::run2 ');
$connector->run();
die;
