<?php

/** ------------------------------------------------------------------------
 * Gloubi Boulga Kerius Finance plugin bootstrap file
 *
 * This file is the entry point of this plugin. It also includes all of its
 * dependencies. The following comments are not only comments, they are used
 * by WordPress to display the plugin information in the plugin admin area.
 * They are also used by Gloubi Boulga's Core plugin to identify his children.
 * In this file, please don't call Gloubi Boulga's Core functions. May be they are
 * not already loaded yet !
 *
 * @link              
 * @package                 Gloubi_Boulga_Kerius_Finance
 *
 * @wordpress-plugin
 * Plugin Name:             Glb Kerius Finance
 * Glb Alias:               Kerius
 * Plugin URI:
 * Description:             Kerius Finance Specificities
 * Version:                 0.0.1
 * Author:                  John Smith
 * Glb Alias:               Kerius
 * Author URI:        
 * License:                 MIT
 * License URI:       
 * Text Domain:             glb-kerius
 * Domain Path:             /langs
 * Priority:                5
------------------------------------------------------------------------ */

// If this file is called directly, abort.
if ( !defined('WPINC') ) { die; }
/**
 * In this file, you can write what you want, it will never be deleted by any plugin update
 * The code below could for example be a site specific code
 */

// Change login header URL, the URL behind the logo link of the login form
function kerius_login_url( $url ) {
    return get_bloginfo( 'url' );
}
add_filter( 'login_headerurl', 'kerius_login_url', 10, 1 );

// Change login header image title
function kerius_login_headertext( $headertext ) {
    return __glbh( 'Welcome to Kerius Finance' );
}

add_filter( 'login_headertext', 'kerius_login_headertext' );

/*
// Customize login message
function na_login_message( $message ) {
    return 'This is our custom message';
}
add_filter( 'login_message', 'na_login_message' );
*/
// Change logout redirect URL
/*function na_logout_redirect( $redirect_to, $requested_redirect_to, $user ) {

    // if user ID is 1, then go to homepage
    if( 1 == $user->ID ){
        return get_bloginfo( 'url' );
    }
    // otherwise go to default redirect url
    return $redirect_to;
}
add_filter( 'logout_redirect', 'na_logout_redirect', 10, 3 );

// Lost password redirect
function na_lostpassword_redirect( $lostpassword_redirect ) {
    return get_permalink( 1 ); // go to page with ID 1
}
add_filter( 'lostpassword_redirect', 'na_lostpassword_redirect' );

// Register redirect
function na_register_redirect( $register_redirect ) {
    return get_permalink( 1 );
}
add_filter( 'registration_redirect', 'na_register_redirect' );*/

// Change login redirect URL to the home page for every body
function kerius_login_redirect( $redirect_to, $requested_redirect_to, $result ) {
    return get_bloginfo( 'url' );
}
add_filter( 'login_redirect', 'kerius_login_redirect', 10, 3 );

// Change logout redirect URL to the home page for every body
function kerius_logout_redirect(){
    wp_redirect( get_bloginfo( 'url' ) );
    exit();
}
add_action('wp_logout','kerius_logout_redirect');


// 10. Add some meta tag in head tag
/*function na_login_head() {
    echo '<meta name="login-head" content="..." />';
}
add_action( 'login_head', 'na_login_head' );

//Add a new stylesheet for login page
function na_login_enqueue_scripts() {
    wp_enqueue_style( 'na-login', get_stylesheet_directory_uri() . '/login.css' );
}
add_action( 'login_enqueue_scripts', 'na_login_enqueue_scripts' );

// 12. Add some text after opening body tag.
function na_login_header() {
    echo 'This is our login page';
}
add_action( 'login_header', 'na_login_header' );

// 13. Add text to login footer
function na_login_footer() {
    echo 'This is our login page footer';
}
add_action( 'login_footer', 'na_login_footer' );*/

// 14. Add new field in register form
/*function na_register_form() {
    ?>
    <p>
        <label for="user_phone"><?php _e('Phone') ?><br />
            <input type="text" name="user_phone" id="user_phone" class="input" size="25" /></label>
    </p>
    <?php
}
add_action( 'register_form', 'na_register_form' );
*/

/*function wpsd_add_login_message() {
    return '<p class="message">' . __glb('It\'s time to login.') . '</p>';
}
add_filter('login_message', 'wpsd_add_login_message');*/

// custom logo for login
function kerius_login_enqueue_scripts() {
    //Glb_Log::notice('kerius_login_enqueue_scripts');
    wp_enqueue_style( 'kerius-login', plugins_url('/files/css/glb-core-login.css', WP_PLUGIN_DIR . '/gloubi-boulga/gloubi-boulga.php') );
    $custom_logo_id = get_theme_mod( 'custom_logo' );
    $image = wp_get_attachment_image_src( $custom_logo_id , 'full' );
    $image_url = $image[0];
    $image_width = min(250, $image[1]);
    $image_height = $image[2];
    if ($image_width == 250) {
        $image_height = $image_height * ($image_width/$image[1]);
    }

    ?>
    <style type="text/css">
        #login h1 a, .login h1 a {
            background-image: url(<?= $image_url ?>);
            background-size: <?=$image_width?>px <?=$image_height?>px;
            width: <?=$image_width?>px;
            height: <?$image_height?>px;
            background-repeat: no-repeat;
        }
    </style>
    <?php
}
add_action( 'login_enqueue_scripts', 'kerius_login_enqueue_scripts' );

function glb_kerius_enqueue_style() {
    wp_enqueue_style( 'glb-kerius-style', plugins_url('glb-kerius-public.css', __FILE__), false );
}

add_action( 'wp_enqueue_scripts', 'glb_kerius_enqueue_style' );

function glb_kerius_disable_header() {
    return '';
}
add_filter( 'generate_navigation_location', 'glb_kerius_disable_header' );

function glb_kerius_generate_copyright() {
    $company = get_option('blogname');
    echo('&copy; 2010 - ' . date('Y') . ' Kerius Finance');
}
add_filter( 'generate_copyright', 'glb_kerius_generate_copyright' );

