<?php

/**
 * I am THE file that defines the Sessions Manager admin specific functionalities
 * I extend Glb_Plugin_Bud, and take profit of all it's functionalities
 *
 * This file is distributed under the same license as the Gloubi_Boulga_Sessions_Manager package.
 *
 * @since             0.0.1
 * @link              
 * @author            John Smith
 * @package           Gloubi_Boulga_Sessions_Manager
 */
class Glb_Sessions_Admin extends Glb_Plugin_Bud {

    public function __construct($plugin) {
        parent::__construct($plugin);

        // add sub menu. No need to add the main menu, as it should be under the Gloubi Boulga main admin menu
        $this->plugin->add_admin_sub_menu('glb_admin_page', 'Sessions', 'Sessions',
            'manage_options', 'glb_sessions_admin_page', array($this, 'glb_sessions_admin_page')
        );

    }

    public function glb_sessions_admin_page() {

        $settings = $this->plugin->settings->get();

        if ($this->request->get_get('tab', 'settings') == 'settings') {

            // save settings if needed
            if ($this->request->get_post('glb_sessions_settings_submit') !== null) {

                $this->request->check_nonce('glb-sessions-settings-edit');
                $settings = $this->plugin->settings->patch_and_save();

                // add admin notice
                $this->notices->add(__glb('Settings saved.'));

            }

        }

        // render admin page
        $this->plugin->render_template('glb-sessions-admin-page', ['settings' => $settings]);
    }

}
