<?php

/** ------------------------------------------------------------------------
* This file has been created by Gloubi Boulga Generator Plugin in order to help
* you understanding the Glb architecture implementation.
* This must be used to create your plugin Admin Page
----------------------------------------------------------------------- */

?>

<div class="wrap">

    <h1><?= __glb('Sessions Manager') ?></h1>

    <?php

    // get current tab
    $current_tab = $this->request->get_get('tab', 'settings');

    // build activity admin table, filtering items for this plugin
    if ($current_tab == 'logs') {

        Glb_Admin_Table_Column::set_table('core_logs');
        $columns = [
            new Glb_Admin_Table_Column('id', false, ['primary' => true]),
            new Glb_Admin_Table_Column('created', __glb('Date'), ['sort' => 'desc']),
            new Glb_Admin_Table_Column('action', __glb('Action'), ['sort' => 'desc', 'search']),
            new Glb_Admin_Table_Column('message', __glb('Message'), ['sort' => 'desc', 'search' => ['message', 'message_args', 'message_details', 'message_details_args']]),
            new Glb_Admin_Table_Column('user_id', false),
            new Glb_Admin_Table_Column('user_description', __glb('User'), ['search', 'sort']),
        ];

        // load data for filters
        $actions = Glb_Table::get('core_logs')->query('select')->modifiers('distinct')
            ->where(['plugin_key' => 'glb-docxplorer'])
            ->fields('action')->order('core_logs.action')->execute()->combine('action', 'action');

        $users = Glb_Table::get('core_users')->query('select')->modifiers('distinct')
            ->order('user_login')->execute()
            ->combine('ID', function($item) {
                return $item->glb_display;
            });

        $filters = [
            'action' => ['label' => 'All actions', 'values' => $actions, 'type' => '%s', 'attrs' => ['data-multiple' => true]],
            'user_id' => ['label' => 'All users', 'values' => $users, 'type' => '%d'] ,
        ];

        // the activity class, Glb_Admin_Table is an extension of WP_List_Table
        $table = new Glb_Admin_Table ( $columns, $filters, null, ['order_by' => 'id', 'order_dir' => 'desc']);

        // get applied filters and interpret them as WHERE
        $applied_filters = $table->get_applied();
        $paging = $table->get_paging();

        // load items
        $items = Glb_Table::get('core_logs')
            ->query('select')
            ->order([$paging['order_by'] => $paging['order_dir']])
            ->limit($paging['per_page'])
            ->where(['core_logs.plugin_key' => 'glb-sessions'])
            ->where($applied_filters);

        glb_dump($items->sql());

        // calculate total item count & execute
        $total_items = $items->count();
        $paging['paged'] = ($total_items < $paging['paged']) ? 0 : $paging['paged'];
        $items->offset($paging['paged']);

        $items = $items->execute();

        $table->set_items($items, $total_items);
        $table->prepare_items();

    }

    

    ?>

    <div id="icon-themes" class="icon32"></div>
    <?php settings_errors(); ?>


    <h2 class="nav-tab-wrapper">
        <a href="admin.php?page=glb_sessions_admin_page&tab=settings" class="nav-tab<?= ($current_tab == 'settings' ? ' nav-tab-active' : '') ?>"><?=__glb('Settings')?></a>
        <a href="admin.php?page=glb_sessions_admin_page&tab=logs" class="nav-tab<?= ($current_tab == 'logs' ? ' nav-tab-active' : '') ?>"><?=__glb('Logs')?></a>
    </h2>

    <form method="POST">

        <?php

        if ($current_tab == 'settings') {

            // the settings tab
            echo '<input type="hidden" name="glb_nonce" value="' . $this->request->create_nonce('glb-sessions-settings-edit') . '">';
            $this->render_template('core:elements/glb-core-admin-settings-table');
            submit_button(__glb('Save changes'), 'primary', 'glb_sessions_settings_submit');

        } else if ($current_tab == 'logs') {

            // the activity tab
            $table->display();

        
        } else if ($current_tab == 'sessions') {

        }
        ?>

    </form>

</div>